/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.mcshare;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.mcshare.MCShare;
import dev.boxadactle.mcshare.Metadata;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Consumer;
import net.lingala.zip4j.ZipFile;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class WorldImporter {
    private static Metadata readMetadata(Path path) {
        try {
            String data = Files.readString(path);
            Gson gson = new GsonBuilder().create();
            Metadata metadata = (Metadata)gson.fromJson(data, Metadata.class);
            if (metadata == null) {
                MCShare.LOGGER.error((Object)"Metadata is null! This is likely an invalid world file!", new Object[0]);
                return null;
            }
            return metadata;
        }
        catch (Exception e) {
            MCShare.LOGGER.error((Object)"Failed to read metadata from the imported world!", new Object[]{e});
            return null;
        }
    }

    private static void moveWorldFiles(Path extracted, ImportOptions options, @Nullable Metadata metadata) {
        try {
            Path worldPath;
            MCShare.LOGGER.info((Object)"Moving world files...", new Object[0]);
            if (metadata != null) {
                worldPath = extracted.resolve("./" + metadata.folderName());
            } else if (Files.exists(extracted.resolve("level.dat"), new LinkOption[0])) {
                worldPath = extracted;
            } else {
                MCShare.LOGGER.warn((Object)"Provided extract is not a minecraft backup or mcshare file!", new Object[0]);
                worldPath = Files.list(extracted).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IOException("No world folder found in the extracted files."));
            }
            if (!Files.exists(worldPath, new LinkOption[0])) {
                throw new IOException("World folder does not exist in the extracted files: " + String.valueOf(worldPath));
            }
            Files.move(worldPath, MCShare.getWorldFolder().resolve(MCShare.generateImport()), StandardCopyOption.REPLACE_EXISTING);
            MCShare.LOGGER.info((Object)("Moved world files to " + String.valueOf(MCShare.getWorldFolder().toAbsolutePath())), new Object[0]);
            MCShare.rmrf(extracted);
            MCShare.LOGGER.info((Object)"Finished!", new Object[0]);
            options.finish.run();
        }
        catch (Exception e) {
            if (e.getMessage().contains("password")) {
                MCShare.LOGGER.warn((Object)"Incorrect password provided!", new Object[0]);
                options.errored.accept("Incorrect password provided!");
                return;
            }
            MCShare.LOGGER.error((Object)"An error occurred while moving world files!", new Object[]{e});
            options.errored.accept(e.getMessage());
        }
    }

    public static void startImport(ImportOptions options) {
        try {
            MCShare.LOGGER.info((Object)"Starting extract...", new Object[0]);
            ZipFile file = new ZipFile(options.path.toFile(), options.password);
            String generated = "mcshare_" + System.currentTimeMillis();
            Path p = MCShare.getTempFolder().resolve(generated);
            MCShare.LOGGER.info((Object)("Extracting to " + String.valueOf(p.toAbsolutePath())), new Object[0]);
            file.extractAll(p.toString());
            Path mfile = p.resolve("mcshare.metadata");
            MCShare.LOGGER.info((Object)("Reading metadata file at " + String.valueOf(mfile.toAbsolutePath())), new Object[0]);
            Metadata metadata = WorldImporter.readMetadata(mfile);
            Screen parent = ClientUtils.getCurrentScreen();
            if (metadata == null) {
                ClientUtils.confirm((Component)Component.m_237115_((String)"message.mcshare.external"), (Component)Component.m_237115_((String)"message.mcshare.anyways"), () -> WorldImporter.a(parent, () -> WorldImporter.moveWorldFiles(p, options, null)), () -> WorldImporter.a(parent, () -> options.errored.accept(I18n.m_118938_((String)"label.mcshare.canceled", (Object[])new Object[0]))));
                return;
            }
            if (metadata.fileVersion() > 1) {
                ClientUtils.confirm((Component)Component.m_237115_((String)"message.mcshare.error.newer"), (Component)Component.m_237115_((String)"message.mcshare.anyways"), () -> WorldImporter.a(parent, () -> WorldImporter.moveWorldFiles(p, options, metadata)), () -> WorldImporter.a(parent, () -> options.errored.accept(I18n.m_118938_((String)"label.mcshare.canceled", (Object[])new Object[0]))));
                return;
            }
            if (MCShare.isNewerVersion(metadata.gameVersion())) {
                ClientUtils.confirm((Component)Component.m_237110_((String)"message.mcshare.error.newer_game", (Object[])new Object[]{metadata.gameVersion()}), (Component)Component.m_237115_((String)"message.mcshare.anyways"), () -> WorldImporter.a(parent, () -> WorldImporter.moveWorldFiles(p, options, metadata)), () -> WorldImporter.a(parent, () -> options.errored.accept(I18n.m_118938_((String)"label.mcshare.canceled", (Object[])new Object[0]))));
                return;
            }
            WorldImporter.moveWorldFiles(p, options, metadata);
        }
        catch (Exception e) {
            MCShare.LOGGER.error((Object)"An error occured while extracting!", new Object[0]);
            MCShare.LOGGER.printStackTrace(e);
            options.errored.accept(e.getMessage());
        }
    }

    private static void a(Screen parent, Runnable r) {
        ClientUtils.getClient().m_91346_(parent);
        r.run();
    }

    public static class ImportOptions {
        Path path;
        Runnable finish;
        Consumer<String> errored;
        char[] password = null;

        public ImportOptions setPath(Path path) {
            this.path = path;
            return this;
        }

        public ImportOptions setFinished(Runnable finish) {
            this.finish = finish;
            return this;
        }

        public ImportOptions setErrored(Consumer<String> errored) {
            this.errored = errored;
            return this;
        }

        public ImportOptions setPassword(String password) {
            if (password == null || password.isBlank()) {
                this.password = null;
                return this;
            }
            this.password = password.toCharArray();
            return this;
        }
    }
}

