/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.mcshare.gui;

import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.field.BStringField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.gui.config.widget.label.BLabel;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.mcshare.MCShare;
import dev.boxadactle.mcshare.WorldExporter;
import dev.boxadactle.mcshare.gui.PathField;
import java.nio.file.Path;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;

public class WorldExportScreen
extends BOptionScreen {
    LevelStorageSource.LevelStorageAccess levelAccess;
    Button export;
    Path path;
    PathField field;
    boolean datapacks = false;
    boolean resourcepacks = false;
    String password = null;

    public WorldExportScreen(Screen parent, LevelStorageSource.LevelStorageAccess levelAccess) {
        super(parent);
        this.levelAccess = levelAccess;
        this.path = MCShare.getDesktop();
    }

    protected Component getName() {
        return Component.m_237119_();
    }

    protected void initFooter(int i, int i1) {
        int number = this.getButtonWidth(BOptionHelper.ButtonType.SMALL);
        this.export = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.mcshare.export.screen"), this::startExport).m_252987_(this.f_96543_ / 2 - number - 1, this.f_96544_ - 25, number, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)GuiUtils.CANCEL, b -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 1, this.f_96544_ - 25, number, 20).m_253136_());
    }

    protected void initConfigButtons() {
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.m_237115_((String)"screen.mcshare.exportworld")));
        this.space();
        this.field = new PathField(this.path, v -> {
            this.path = v;
        });
        this.field.m_94199_(512);
        this.addConfigLine((BOptionEntry)this.field, (BOptionEntry)new BLabel((Component)Component.m_237113_((String)".mcshare")));
        this.space();
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.m_237115_((String)"screen.mcshare.exportworld.settings")));
        this.addConfigLine((BOptionEntry)new BBooleanButton("button.mcshare.export.resourcepacks", Boolean.valueOf(this.resourcepacks), n -> {
            this.resourcepacks = n;
        }));
        this.addConfigLine((BOptionEntry)new BBooleanButton("button.mcshare.export.datapacks", Boolean.valueOf(this.datapacks), n -> {
            this.datapacks = n;
        }));
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.m_237115_((String)"label.mcshare.password")));
        this.addConfigLine((BOptionEntry)new BStringField("", s -> {
            this.password = s;
        }));
    }

    private void startExport(Button ignored) {
        ClientUtils.getClient().m_91346_((Screen)new ExportingScreen(this.parent, this.levelAccess, this.path));
        WorldExporter.ExportOptions options = new WorldExporter.ExportOptions().setExportPath(this.path).setWorldPath(this.levelAccess.m_78283_(LevelResource.f_78182_)).setIncludeDatapacks(this.datapacks).setIncludeResourcepacks(this.resourcepacks).setPassword(this.password.isBlank() ? null : this.password).setFinished(() -> ((ExportingScreen)ClientUtils.getCurrentScreen()).setFinished()).setErrored(((ExportingScreen)ClientUtils.getCurrentScreen())::setErrored);
        WorldExporter.startExport(options);
    }

    private void space() {
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
    }

    public static class ExportingScreen
    extends Screen {
        Screen parent;
        boolean isFinished;
        boolean isError;
        String error;
        Path path;
        Button doneButton;
        Button openButton;

        protected ExportingScreen(Screen parent, LevelStorageSource.LevelStorageAccess access, Path filePath) {
            super((Component)Component.m_237110_((String)"screen.mcshare.exporting", (Object[])new Object[]{access.m_78277_()}));
            this.parent = parent;
            this.path = filePath;
            MCShare.LOGGER.info((Object)"hello screen", new Object[0]);
        }

        public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_88315_(guiGraphics, i, j, f);
            if (!this.isError) {
                guiGraphics.m_280653_(this.f_96547_, (Component)(this.isFinished ? Component.m_237115_((String)"message.mcshare.finished.export") : this.f_96539_), this.f_96543_ / 2, this.f_96544_ / 2 - 60, 0xFFFFFF);
            } else {
                guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"message.mcshare.finished.export.error"), this.f_96543_ / 2, this.f_96544_ / 2 - 60, 0xFFFFFF);
                guiGraphics.m_280137_(this.f_96547_, this.error, this.f_96543_, this.f_96544_ / 2 - 45, 0xAA0000);
            }
        }

        protected void m_7856_() {
            int number = BOptionHelper.buttonWidth((BOptionHelper.ButtonType)BOptionHelper.ButtonType.SMALL);
            this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)GuiUtils.DONE, b -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - number - 1, this.f_96544_ / 2 + 40, number, 20).m_253136_());
            this.openButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.mcshare.open"), this::openFile).m_252987_(this.f_96543_ / 2 + 1, this.f_96544_ / 2 + 40, number, 20).m_253136_());
            this.doneButton.f_93624_ = false;
            this.doneButton.f_93623_ = false;
            this.openButton.f_93624_ = false;
            this.openButton.f_93623_ = false;
        }

        private void openFile(Button b) {
            Util.m_137581_().m_137644_(this.path.getParent().toFile());
        }

        public void setFinished() {
            this.isFinished = true;
            this.activateButtons(true);
        }

        public void setErrored(String error) {
            this.isError = true;
            this.error = error;
            this.activateButtons(false);
        }

        private void activateButtons(boolean bl) {
            this.doneButton.f_93624_ = true;
            this.openButton.f_93624_ = true;
            this.doneButton.f_93623_ = true;
            this.openButton.f_93623_ = bl;
            MCShare.LOGGER.info((Object)"ExportingScreen buttons activated", new Object[0]);
        }

        public boolean m_6913_() {
            return this.isFinished || this.isError;
        }

        public void m_7379_() {
            this.f_96541_.m_91152_(this.parent);
        }
    }
}

