/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.mcshare.gui;

import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.field.BStringField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.mcshare.MCShare;
import dev.boxadactle.mcshare.WorldImporter;
import dev.boxadactle.mcshare.gui.PathField;
import dev.boxadactle.mcshare.mixin.CreateWorldParentAccessor;
import dev.boxadactle.mcshare.mixin.SelectWorldParentAccessor;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;

public class WorldImportScreen
extends BOptionScreen {
    Button confirm;
    Path path;
    PathField field;
    String password = null;

    public WorldImportScreen(Screen parent) {
        this(parent, MCShare.getDesktop());
    }

    public WorldImportScreen(Screen parent, Path path) {
        super(parent);
        this.path = path;
    }

    protected Component getName() {
        return Component.m_237119_();
    }

    protected void initFooter(int i, int i1) {
        int number = this.getButtonWidth(BOptionHelper.ButtonType.SMALL);
        this.confirm = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.mcshare.import.screen"), this::startImport).m_252987_(this.f_96543_ / 2 - number - 1, this.f_96544_ - 25, number, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)GuiUtils.CANCEL, b -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 1, this.f_96544_ - 25, number, 20).m_253136_());
    }

    protected void initConfigButtons() {
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.m_237115_((String)"screen.mcshare.importworld")));
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.m_237115_((String)"label.mcshare.dragging")));
        this.space();
        this.field = new PathField(this.path, v -> {
            this.path = v;
        });
        this.field.m_94199_(512);
        this.addConfigLine((BOptionEntry)this.field);
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.m_237115_((String)"label.mcshare.password")));
        this.addConfigLine((BOptionEntry)new BStringField("", s -> {
            this.password = s;
        }));
    }

    public void m_7400_(List<Path> list) {
        for (Path p : list) {
            if (!p.toString().endsWith(".mcshare") && !p.toString().endsWith(".zip")) continue;
            this.path = p;
            this.field.m_94144_(this.field.from(p));
            this.field.valid();
            break;
        }
    }

    private void space() {
        this.addConfigLine((BOptionEntry)new BSpacingEntry());
    }

    private void startImport(Button b) {
        ClientUtils.getClient().m_91346_((Screen)new ImportingScreen(this.parent, this.path.getFileName().toString()));
        WorldImporter.ImportOptions options = new WorldImporter.ImportOptions().setPath(this.path).setPassword(this.password.isEmpty() ? null : this.password).setFinished(() -> ((ImportingScreen)ClientUtils.getClient().f_91080_).setFinished()).setErrored(s -> ((ImportingScreen)ClientUtils.getClient().f_91080_).setErrored((String)s));
        WorldImporter.startImport(options);
    }

    public static class ImportingScreen
    extends Screen {
        Screen parent;
        boolean isFinished = false;
        boolean isError = false;
        String error;
        String worldName;
        Button doneButton;
        Button playButton;
        List<String> worldFiles;

        protected ImportingScreen(Screen parent, String name) {
            super((Component)Component.m_237110_((String)"screen.mcshare.importing", (Object[])new Object[]{name}));
            this.worldName = name;
            this.parent = parent;
            Path worldFolder = MCShare.getWorldFolder();
            this.worldFiles = List.of(worldFolder.toFile().list((dir, name1) -> dir.isDirectory()));
        }

        public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_88315_(guiGraphics, i, j, f);
            if (!this.isError) {
                guiGraphics.m_280653_(this.f_96547_, (Component)(this.isFinished ? Component.m_237115_((String)"message.mcshare.finished.import") : this.f_96539_), this.f_96543_ / 2, this.f_96544_ / 2 - 60, 0xFFFFFF);
            } else {
                guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"message.mcshare.finished.import.error"), this.f_96543_ / 2, this.f_96544_ / 2 - 60, 0xFFFFFF);
                guiGraphics.m_280137_(this.f_96547_, this.error.trim(), this.f_96543_, this.f_96544_ / 2 - 45, 0xAA0000);
            }
        }

        protected void m_7856_() {
            int number = BOptionHelper.buttonWidth((BOptionHelper.ButtonType)BOptionHelper.ButtonType.SMALL);
            this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)GuiUtils.DONE, b -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - number - 1, this.f_96544_ - 40, number, 20).m_253136_());
            this.playButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.mcshare.play"), this::playWorld).m_252987_(this.f_96543_ / 2 + 1, this.f_96544_ - 40, number, 20).m_253136_());
            this.doneButton.f_93624_ = false;
            this.doneButton.f_93623_ = false;
            this.playButton.f_93624_ = false;
            this.playButton.f_93623_ = false;
        }

        private void playWorld(Button button) {
            Path worldFolder = MCShare.getWorldFolder();
            for (String file : worldFolder.toFile().list((dir, name1) -> dir.isDirectory())) {
                if (this.worldFiles.contains(file)) continue;
                this.f_96541_.m_231466_().m_306404_(file, () -> this.f_96541_.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"message.mcshare.open"))));
                break;
            }
            ClientUtils.setScreen((Screen)new SelectWorldScreen((Screen)new TitleScreen()));
            ClientUtils.showToast((Component)Component.m_237115_((String)"message.mcshare.open.error"), (Component)Component.m_237115_((String)"message.mcshare.open.error.2"));
        }

        public void setFinished() {
            this.isFinished = true;
            this.activateButtons(true);
        }

        public void setErrored(String errorMessage) {
            this.isError = true;
            this.error = errorMessage;
            this.activateButtons(false);
        }

        private void activateButtons(boolean bl) {
            this.doneButton.f_93624_ = true;
            this.playButton.f_93624_ = true;
            this.doneButton.f_93623_ = true;
            this.playButton.f_93623_ = bl;
            MCShare.LOGGER.info((Object)"ImportingScreen buttons activated", new Object[0]);
        }

        public boolean m_6913_() {
            return this.isFinished || this.isError;
        }

        public void m_7379_() {
            if (this.parent instanceof SelectWorldScreen) {
                this.f_96541_.m_91152_((Screen)new SelectWorldScreen(((SelectWorldParentAccessor)this.parent).getParent()));
            } else if (this.parent instanceof CreateWorldScreen) {
                this.f_96541_.m_91152_((Screen)new SelectWorldScreen(((CreateWorldParentAccessor)this.parent).getParent()));
            } else {
                MCShare.LOGGER.error((Object)"Parent was not an instance of {} or {}", new Object[]{SelectWorldScreen.class, CreateWorldScreen.class});
                this.f_96541_.m_91152_((Screen)new TitleScreen());
            }
        }
    }
}

