/*
 * Decompiled with CFR 0.152.
 */
package fun.breezemc.coinflip;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.ess3.api.Economy;
import net.ess3.api.MaxMoneyException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CoinFlipPlugin
extends JavaPlugin
implements Listener {
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private long cooldownTime;
    private int inventorySlots;
    private boolean broadcastEnabled;
    private Material headsMaterial;
    private Material tailsMaterial;
    private String winMessage;
    private String loseMessage;
    private String winBroadcast;
    private String loseBroadcast;
    private double minBet;
    private double maxBet;
    private Sound winSound;
    private Sound loseSound;
    private Sound flipSound;
    private long animationDuration;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        CoinFlipCommand commandExecutor = new CoinFlipCommand();
        this.getCommand("coinflip").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("coinflip").setTabCompleter((TabCompleter)commandExecutor);
        this.getCommand("cf").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("cf").setTabCompleter((TabCompleter)commandExecutor);
    }

    private void loadConfig() {
        this.inventorySlots = this.getConfig().getInt("inventory-slots", 27);
        if (this.inventorySlots % 9 != 0 || this.inventorySlots < 9 || this.inventorySlots > 54) {
            this.inventorySlots = 27;
            this.getLogger().warning("Invalid inventory-slots in config, using default: 27");
        }
        this.broadcastEnabled = this.getConfig().getBoolean("broadcast-enabled", true);
        this.cooldownTime = this.getConfig().getLong("command-cooldown", 30L) * 1000L;
        this.minBet = this.getConfig().getDouble("min-bet", 1000.0);
        this.maxBet = this.getConfig().getDouble("max-bet", 10000.0);
        this.animationDuration = this.getConfig().getLong("animation-duration", 7L) * 1000L;
        String headsMaterialName = this.getConfig().getString("heads-material", "CREEPER_HEAD");
        String tailsMaterialName = this.getConfig().getString("tails-material", "BRUSH");
        this.headsMaterial = this.getMaterial(headsMaterialName, Material.CREEPER_HEAD);
        this.tailsMaterial = this.getMaterial(tailsMaterialName, Material.BRUSH);
        this.winMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("win-message", "&aYou won! Your balance has been increased by ${formatted_amount}!"));
        this.loseMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("lose-message", "&cYou lost! ${formatted_amount} has been deducted from your balance."));
        this.winBroadcast = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("win-broadcast", "&a{player} won ${formatted_amount} from a coin flip!"));
        this.loseBroadcast = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("lose-broadcast", "&c{player} lost ${formatted_amount} from a coin flip!"));
        this.winSound = this.getSound(this.getConfig().getString("win-sound", "ENTITY_FIREWORK_ROCKET_BLAST"), Sound.ENTITY_FIREWORK_ROCKET_BLAST);
        this.loseSound = this.getSound(this.getConfig().getString("lose-sound", "ENTITY_IRON_GOLEM_DAMAGE"), Sound.ENTITY_IRON_GOLEM_DAMAGE);
        this.flipSound = this.getSound(this.getConfig().getString("flip-sound", "ENTITY_EXPERIENCE_ORB_PICKUP"), Sound.ENTITY_EXPERIENCE_ORB_PICKUP);
    }

    private Material getMaterial(String materialName, Material fallback) {
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            this.getLogger().warning("Invalid material '" + materialName + "' in config, using default: " + fallback.name());
            return fallback;
        }
        return material;
    }

    private Sound getSound(String soundName, Sound fallback) {
        try {
            return Sound.valueOf((String)soundName);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid sound '" + soundName + "' in config, using default: " + fallback.name());
            return fallback;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals("Coin Flip")) {
            event.setCancelled(true);
        }
    }

    public class CoinFlipCommand
    implements CommandExecutor,
    TabCompleter {
        private final Random random = new Random();
        private final ItemStack headsItem;
        private final ItemStack tailsItem;
        private final DecimalFormat formatter = new DecimalFormat("#,###.##");

        public CoinFlipCommand() {
            this.headsItem = new ItemStack(CoinFlipPlugin.this.headsMaterial);
            ItemMeta headsMeta = this.headsItem.getItemMeta();
            headsMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Heads");
            this.headsItem.setItemMeta(headsMeta);
            this.tailsItem = new ItemStack(CoinFlipPlugin.this.tailsMaterial);
            ItemMeta tailsMeta = this.tailsItem.getItemMeta();
            tailsMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Tails");
            this.tailsItem.setItemMeta(tailsMeta);
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            double amount;
            long lastUsed;
            long timeSinceLastUse;
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
                return true;
            }
            Player player = (Player)sender;
            UUID playerId = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            if (CoinFlipPlugin.this.cooldowns.containsKey(playerId) && (timeSinceLastUse = currentTime - (lastUsed = CoinFlipPlugin.this.cooldowns.get(playerId).longValue())) < CoinFlipPlugin.this.cooldownTime) {
                long secondsLeft = (CoinFlipPlugin.this.cooldownTime - timeSinceLastUse) / 1000L;
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + secondsLeft + " seconds before using this command again!");
                return true;
            }
            if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
                this.showHelp(player, label);
                return true;
            }
            if (args.length != 2) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /" + label + " <amount> <heads/tails>");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Use /" + label + " help for more information");
                return true;
            }
            try {
                amount = Double.parseDouble(args[0]);
                if (amount < CoinFlipPlugin.this.minBet) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Minimum bet amount is " + this.formatter.format(CoinFlipPlugin.this.minBet) + "!");
                    return true;
                }
                if (amount > CoinFlipPlugin.this.maxBet) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Maximum bet amount is " + this.formatter.format(CoinFlipPlugin.this.maxBet) + "!");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount!");
                return true;
            }
            String choice = args[1].toLowerCase();
            if (!choice.equals("heads") && !choice.equals("tails")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please choose either heads or tails!");
                return true;
            }
            try {
                BigDecimal balance = Economy.getMoneyExact((UUID)player.getUniqueId());
                if (balance.doubleValue() < amount) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough money!");
                    return true;
                }
            }
            catch (Exception e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error checking balance!");
                return true;
            }
            CoinFlipPlugin.this.cooldowns.put(playerId, currentTime);
            this.startCoinFlip(player, amount, choice);
            return true;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            if (args.length == 1) {
                return Arrays.asList(String.valueOf(CoinFlipPlugin.this.minBet), String.valueOf(CoinFlipPlugin.this.maxBet / 2.0), String.valueOf(CoinFlipPlugin.this.maxBet), "help").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 2) {
                return Arrays.asList("heads", "tails").stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        private void showHelp(Player player, String label) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== CoinFlip Commands ===");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " <amount> <heads/tails> - Start a coin flip (" + CoinFlipPlugin.this.cooldownTime / 1000L + "s cooldown)");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " help - Show this help message");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Min bet: " + this.formatter.format(CoinFlipPlugin.this.minBet) + " | Max bet: " + this.formatter.format(CoinFlipPlugin.this.maxBet));
        }

        private void startCoinFlip(final Player player, final double amount, final String choice) {
            final Inventory gui = Bukkit.createInventory(null, (int)CoinFlipPlugin.this.inventorySlots, (String)"Coin Flip");
            final int middleSlot = CoinFlipPlugin.this.inventorySlots / 2;
            gui.setItem(middleSlot, this.headsItem);
            player.openInventory(gui);
            new BukkitRunnable(){
                long startTime;
                long lastUpdate;
                boolean isHeadsItem;
                {
                    this.lastUpdate = this.startTime = System.currentTimeMillis();
                    this.isHeadsItem = true;
                }

                public void run() {
                    long currentTime = System.currentTimeMillis();
                    long elapsedTime = currentTime - this.startTime;
                    if (elapsedTime >= CoinFlipPlugin.this.animationDuration) {
                        boolean isHeads = CoinFlipCommand.this.random.nextBoolean();
                        ItemStack finalItem = isHeads ? CoinFlipCommand.this.headsItem : CoinFlipCommand.this.tailsItem;
                        gui.setItem(middleSlot, finalItem);
                        boolean playerWins = isHeads && choice.equals("heads") || !isHeads && choice.equals("tails");
                        try {
                            if (playerWins) {
                                Economy.add((UUID)player.getUniqueId(), (BigDecimal)BigDecimal.valueOf(amount * 2.0));
                                String message = CoinFlipPlugin.this.winMessage.replace("{player}", player.getName()).replace("{amount}", String.valueOf(amount * 2.0)).replace("{formatted_amount}", CoinFlipCommand.this.formatter.format(amount * 2.0));
                                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                                if (CoinFlipPlugin.this.broadcastEnabled) {
                                    String broadcast = CoinFlipPlugin.this.winBroadcast.replace("{player}", player.getName()).replace("{amount}", String.valueOf(amount * 2.0)).replace("{formatted_amount}", CoinFlipCommand.this.formatter.format(amount * 2.0));
                                    Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)broadcast));
                                }
                                player.playSound(player.getLocation(), CoinFlipPlugin.this.winSound, 1.0f, 1.0f);
                            } else {
                                Economy.subtract((UUID)player.getUniqueId(), (BigDecimal)BigDecimal.valueOf(amount));
                                String message = CoinFlipPlugin.this.loseMessage.replace("{player}", player.getName()).replace("{amount}", String.valueOf(amount)).replace("{formatted_amount}", CoinFlipCommand.this.formatter.format(amount));
                                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                                if (CoinFlipPlugin.this.broadcastEnabled) {
                                    String broadcast = CoinFlipPlugin.this.loseBroadcast.replace("{player}", player.getName()).replace("{amount}", String.valueOf(amount)).replace("{formatted_amount}", CoinFlipCommand.this.formatter.format(amount));
                                    Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)broadcast));
                                }
                                player.playSound(player.getLocation(), CoinFlipPlugin.this.loseSound, 1.0f, 1.0f);
                            }
                        }
                        catch (MaxMoneyException e) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Balance too large!");
                        }
                        catch (Exception e) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Error updating balance!");
                        }
                        new BukkitRunnable(){

                            public void run() {
                                player.closeInventory();
                            }
                        }.runTaskLater((Plugin)CoinFlipPlugin.this, 20L);
                        this.cancel();
                        return;
                    }
                    long minDelay = 50L;
                    long maxDelay = 500L;
                    double progress = (double)elapsedTime / (double)CoinFlipPlugin.this.animationDuration;
                    long delay = (long)((double)minDelay + (double)(maxDelay - minDelay) * progress);
                    if (currentTime - this.lastUpdate >= delay) {
                        this.isHeadsItem = !this.isHeadsItem;
                        gui.setItem(middleSlot, this.isHeadsItem ? CoinFlipCommand.this.headsItem : CoinFlipCommand.this.tailsItem);
                        player.playSound(player.getLocation(), CoinFlipPlugin.this.flipSound, 1.0f, 1.0f);
                        this.lastUpdate = currentTime;
                    }
                }
            }.runTaskTimer((Plugin)CoinFlipPlugin.this, 0L, 1L);
        }
    }
}

