/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.create_unbreakable.block.custom;

import java.util.Collections;
import java.util.List;
import net.anvian.create_unbreakable.CreateUnbreakableToolsMod;
import net.anvian.create_unbreakable.block.custom.EternalBlock;
import net.anvian.create_unbreakable.config.ModConfigs;
import net.anvian.create_unbreakable.item.ModItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LuminarchyBlock
extends EternalBlock {
    public LuminarchyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.isClientSide && ((ModConfigs.CreateUnbreakableConfig)CreateUnbreakableToolsMod.configs.getConfig()).luminarchyExplosionAtBreak) {
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 3.0f, false, Explosion.BlockInteraction.BREAK);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public List<ItemStack> getDrops(BlockState blockState, LootContext.Builder builder) {
        if (((ItemStack)builder.getOptionalParameter(LootContextParams.TOOL)).isCorrectToolForDrops(blockState)) {
            ListTag enchantments;
            int i;
            ItemStack tool = (ItemStack)builder.getOptionalParameter(LootContextParams.TOOL);
            if (tool != null && tool.hasTag() && tool.getTag().contains("Enchantments") && (i = 0) < (enchantments = tool.getTag().getList("Enchantments", 10)).size()) {
                CompoundTag enchantment = enchantments.getCompound(i);
                if (enchantment.getString("id").equals("minecraft:silk_touch")) {
                    return Collections.singletonList(new ItemStack((ItemLike)this));
                }
                return Collections.singletonList(new ItemStack((ItemLike)ModItem.LUMINARCHY.get()));
            }
            return Collections.singletonList(new ItemStack((ItemLike)ModItem.LUMINARCHY.get()));
        }
        return super.getDrops(blockState, builder);
    }
}

