/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.create_unbreakable.mixin;

import java.util.Map;
import net.anvian.create_unbreakable.CreateUnbreakableToolsMod;
import net.anvian.create_unbreakable.config.ModConfigs;
import net.anvian.create_unbreakable.item.ModItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    @Final
    private DataSlot f_39002_;

    public AnvilMenuMixin(@Nullable MenuType<?> type, int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(type, containerId, playerInventory, access);
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject(CallbackInfo info) {
        ItemStack itemStack1 = this.inputSlots.getItem(0).copy();
        ItemStack itemStack2 = this.inputSlots.getItem(1);
        if (itemStack1.isDamageableItem() && itemStack2.is((Item)ModItem.IRROMOLDING.get())) {
            int mendingLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.MENDING, (ItemStack)itemStack1);
            if (((ModConfigs.CreateUnbreakableConfig)CreateUnbreakableToolsMod.configs.getConfig()).apply_on_mending || mendingLevel == 0) {
                this.f_39002_.set(10);
                CompoundTag nbt = itemStack1.getOrCreateTag();
                nbt.putBoolean("Unbreakable", true);
                itemStack1.setTag(nbt);
                itemStack1.setDamageValue(0);
                this.resultSlots.setItem(0, itemStack1);
                this.broadcastChanges();
                info.cancel();
            }
        }
        Map enchantment = EnchantmentHelper.getEnchantments((ItemStack)itemStack2);
        boolean mending = enchantment.containsKey(Enchantments.MENDING);
        if (itemStack1.hasTag() && itemStack1.getTag().getBoolean("Unbreakable") && mending) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.f_39002_.set(0);
            this.broadcastChanges();
            info.cancel();
        }
    }
}

