/*
 * Decompiled with CFR 0.152.
 */
package at.yedel.advantimations.config;

import at.yedel.advantimations.config.FirstPersonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_746;

public class EntityOption
implements FirstPersonOption {
    protected boolean enabled;
    protected boolean enabledInFirstPerson;
    protected boolean enabledOnSelf;
    protected boolean enabledOnOtherPlayers;
    protected boolean enabledOnOtherEntities;

    @Override
    public boolean shouldApplyInFirstPerson() {
        return this.enabled && this.enabledInFirstPerson;
    }

    public <T> T getThirdPersonResult(class_1297 entity, T originalValue, T newValue) {
        if (this.enabled) {
            class_1657 player;
            if (this.enabledOnSelf && entity instanceof class_746) {
                return newValue;
            }
            if (this.enabledOnOtherPlayers && entity instanceof class_1657 && !(player = (class_1657)entity).method_7340()) {
                return newValue;
            }
            if (this.enabledOnOtherEntities && !(entity instanceof class_1657)) {
                return newValue;
            }
        }
        return originalValue;
    }

    public static OptionGroup createGroup(String groupName, String groupDescription, EntityOption defaultValue, EntityOption configValue, Consumer<Configuration> configurator) {
        Configuration configuration = new Configuration();
        configurator.accept(configuration);
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)groupName)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)groupDescription)})).collapsed(configuration.collapsed).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).binding((Object)defaultValue.isEnabled(), configValue::isEnabled, configValue::setEnabled).controller(BooleanControllerBuilder::create).build()).optionIf(configuration.canBeEnabledInFirstPerson, Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled in First Person")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable this option for yourself in first person.")})).binding((Object)defaultValue.enabledInFirstPerson, configValue::isEnabledInFirstPerson, configValue::setEnabledInFirstPerson).controller(TickBoxControllerBuilder::create).build()).optionIf(configuration.canBeEnabledOnSelf, Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled on Self")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable this option for yourself.")})).binding((Object)defaultValue.isEnabledOnSelf(), configValue::isEnabledOnSelf, configValue::setEnabledOnSelf).controller(TickBoxControllerBuilder::create).build()).optionIf(configuration.canBeEnabledOnOtherPlayers, Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled on Other Players")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable this option for other players.")})).binding((Object)defaultValue.isEnabledOnOtherPlayers(), configValue::isEnabledOnOtherPlayers, configValue::setEnabledOnOtherPlayers).controller(TickBoxControllerBuilder::create).build()).optionIf(configuration.canBeEnabledOnOtherEntities, Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled on Other Entities")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable this option for other non-player entities, such as zombies.")})).binding((Object)defaultValue.isEnabledOnOtherEntities(), configValue::isEnabledOnOtherEntities, configValue::setEnabledOnOtherEntities).controller(TickBoxControllerBuilder::create).build()).build();
    }

    public EntityOption enabled() {
        this.enabled = true;
        return this;
    }

    public EntityOption enabledInFirstPerson() {
        this.enabledInFirstPerson = true;
        return this;
    }

    public EntityOption enabledOnSelf() {
        this.enabledOnSelf = true;
        return this;
    }

    public EntityOption enabledOnOtherPlayers() {
        this.enabledOnOtherPlayers = true;
        return this;
    }

    public EntityOption enabledOnOtherEntities() {
        this.enabledOnOtherEntities = true;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabledInFirstPerson() {
        return this.enabledInFirstPerson;
    }

    public void setEnabledInFirstPerson(boolean enabledInFirstPerson) {
        this.enabledInFirstPerson = enabledInFirstPerson;
    }

    public boolean isEnabledOnSelf() {
        return this.enabledOnSelf;
    }

    public void setEnabledOnSelf(boolean enabledOnSelf) {
        this.enabledOnSelf = enabledOnSelf;
    }

    public boolean isEnabledOnOtherPlayers() {
        return this.enabledOnOtherPlayers;
    }

    public void setEnabledOnOtherPlayers(boolean enabledOnOtherPlayers) {
        this.enabledOnOtherPlayers = enabledOnOtherPlayers;
    }

    public boolean isEnabledOnOtherEntities() {
        return this.enabledOnOtherEntities;
    }

    public void setEnabledOnOtherEntities(boolean enabledOnOtherEntities) {
        this.enabledOnOtherEntities = enabledOnOtherEntities;
    }

    public static class Configuration {
        public static final Consumer<Configuration> PERSPECTIVE_INDEPENDENT_OPTION_CONFIGURATOR = configuration -> configuration.canBeEnabledInFirstPerson().canBeEnabledOnSelf().canBeEnabledOnOtherPlayers().canBeEnabledOnOtherEntities();
        public static final Consumer<Configuration> THIRD_PERSON_OPTION_CONFIGURATOR = configuration -> configuration.canBeEnabledOnSelf().canBeEnabledOnOtherPlayers().canBeEnabledOnOtherEntities();
        private boolean canBeEnabledInFirstPerson;
        private boolean canBeEnabledOnSelf;
        private boolean canBeEnabledOnOtherPlayers;
        private boolean canBeEnabledOnOtherEntities;
        private boolean collapsed;

        public Configuration canBeEnabledInFirstPerson() {
            this.canBeEnabledInFirstPerson = true;
            return this;
        }

        public Configuration canBeEnabledOnSelf() {
            this.canBeEnabledOnSelf = true;
            return this;
        }

        public Configuration canBeEnabledOnOtherPlayers() {
            this.canBeEnabledOnOtherPlayers = true;
            return this;
        }

        public Configuration canBeEnabledOnOtherEntities() {
            this.canBeEnabledOnOtherEntities = true;
            return this;
        }

        public Configuration collapsed() {
            this.collapsed = true;
            return this;
        }
    }
}

