/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.beanplanet;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.beanplanet.BeanPlanetMod;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class BeanPlanetModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public BeanPlanetModElements() {
        sounds.put(new ResourceLocation("bean_planet", "fak_you"), new SoundEvent(new ResourceLocation("bean_planet", "fak_you")));
        sounds.put(new ResourceLocation("bean_planet", "musket_shooting"), new SoundEvent(new ResourceLocation("bean_planet", "musket_shooting")));
        sounds.put(new ResourceLocation("bean_planet", "boltaction"), new SoundEvent(new ResourceLocation("bean_planet", "boltaction")));
        sounds.put(new ResourceLocation("bean_planet", "actualboltactionsound"), new SoundEvent(new ResourceLocation("bean_planet", "actualboltactionsound")));
        sounds.put(new ResourceLocation("bean_planet", "overworldtypebeat"), new SoundEvent(new ResourceLocation("bean_planet", "overworldtypebeat")));
        sounds.put(new ResourceLocation("bean_planet", "ha_ha_ha_song"), new SoundEvent(new ResourceLocation("bean_planet", "ha_ha_ha_song")));
        sounds.put(new ResourceLocation("bean_planet", "space_world_type_beat"), new SoundEvent(new ResourceLocation("bean_planet", "space_world_type_beat")));
        sounds.put(new ResourceLocation("bean_planet", "thebucket"), new SoundEvent(new ResourceLocation("bean_planet", "thebucket")));
        sounds.put(new ResourceLocation("bean_planet", "spooky_ass_level"), new SoundEvent(new ResourceLocation("bean_planet", "spooky_ass_level")));
        sounds.put(new ResourceLocation("bean_planet", "m16_gun_shot"), new SoundEvent(new ResourceLocation("bean_planet", "m16_gun_shot")));
        sounds.put(new ResourceLocation("bean_planet", "pistol_gun_shot"), new SoundEvent(new ResourceLocation("bean_planet", "pistol_gun_shot")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("bean_planet").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        BeanPlanetMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final BeanPlanetModElements elements;
        protected final int sortid;

        public ModElement(BeanPlanetModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

