/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.sloobix.nougatadditions.generals.NAFileWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Generation {
    public static final boolean DEFAULT_GENERATION = false;
    public static boolean REPLACE_TEMPLATE;
    private static final Gson GSON;
    private static final ExecutorService IO_EXECUTOR;
    private static final Path CONFIG_PATH;

    private static void loadConfig() {
        JsonObject json = new JsonObject();
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        REPLACE_TEMPLATE = json.has("Replace_Template") ? json.get("Replace_Template").getAsBoolean() : false;
    }

    private static void saveAsync() {
        IO_EXECUTOR.submit(() -> {
            JsonObject conf = new JsonObject();
            conf.addProperty("Replace_Template", Boolean.valueOf(REPLACE_TEMPLATE));
            NAFileWriter.writeToFile(CONFIG_PATH, conf);
        });
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        IO_EXECUTOR = Executors.newSingleThreadExecutor();
        CONFIG_PATH = Path.of("config", "nougatadditions", "generation.json");
        CONFIG_PATH.getParent().toFile().mkdirs();
        if (!CONFIG_PATH.toFile().exists()) {
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                writer.write("{}");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JsonObject replace = new JsonObject();
            replace.addProperty("Replace_Template", Boolean.valueOf(true));
            NAFileWriter.writeToFile(CONFIG_PATH, replace);
        }
        Generation.loadConfig();
    }
}

