/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sloobix.nougatadditions.generals.NAFileWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Lives {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ExecutorService IO_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final Path CONFIG_PATH = Path.of("config", "nougatadditions", "lives.json");
    private static final Map<UUID, Integer> LIVES_MAP = new HashMap<UUID, Integer>();
    private static final Map<UUID, String> NAMES_MAP = new HashMap<UUID, String>();

    public static boolean hasEntry(UUID playerId) {
        return LIVES_MAP.containsKey(playerId);
    }

    public static int getLives(UUID playerId) {
        return LIVES_MAP.getOrDefault(playerId, 0);
    }

    public static void die(UUID playerId) {
        LIVES_MAP.put(playerId, LIVES_MAP.get(playerId) - 1);
        Lives.saveAsync();
    }

    public static void setLives(UUID playerId, String name, int lives) {
        LIVES_MAP.put(playerId, lives);
        NAMES_MAP.put(playerId, name);
        Lives.saveAsync();
    }

    public static void addLive(UUID playerId) {
        LIVES_MAP.put(playerId, LIVES_MAP.get(playerId) + 1);
        Lives.saveAsync();
    }

    public static void loadConfig() {
        LIVES_MAP.clear();
        NAMES_MAP.clear();
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root != null) {
                for (Map.Entry entry : root.entrySet()) {
                    try {
                        UUID uuid = UUID.fromString((String)entry.getKey());
                        JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                        int lives = obj.get("lives").getAsInt();
                        String name = obj.get("name").getAsString();
                        LIVES_MAP.put(uuid, lives);
                        NAMES_MAP.put(uuid, name);
                    }
                    catch (Exception e) {
                        System.err.println("Invalid entry in lives.json: " + String.valueOf(entry));
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Could not load lives.json: " + e.getMessage());
        }
    }

    private static void saveAsync() {
        IO_EXECUTOR.submit(() -> {
            JsonObject root = new JsonObject();
            for (Map.Entry<UUID, Integer> entry : LIVES_MAP.entrySet()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("name", NAMES_MAP.get(entry.getKey()));
                obj.addProperty("lives", (Number)entry.getValue());
                root.add(entry.getKey().toString(), (JsonElement)obj);
            }
            NAFileWriter.writeToFile(CONFIG_PATH, root);
        });
    }

    static {
        CONFIG_PATH.getParent().toFile().mkdirs();
        if (!CONFIG_PATH.toFile().exists()) {
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                writer.write("{}");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Lives.loadConfig();
    }
}

