/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.datagen;

import com.sloobix.nougatadditions.ModItems;
import com.sloobix.nougatadditions.config.Generation;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import plus.dragons.createdragonsplus.config.CDPConfig;

public class NALoots {

    @EventBusSubscriber
    public static class TableInjections {
        public static final Object2IntMap EMPTY_BLAZE_UPGRADE_TEMPLATE = (Object2IntMap)Util.make((Object)new Object2IntOpenHashMap(), map -> {
            map.put((Object)BuiltInLootTables.BASTION_TREASURE.location(), 1);
            map.put((Object)BuiltInLootTables.BASTION_OTHER.location(), 10);
            map.put((Object)BuiltInLootTables.BASTION_BRIDGE.location(), 10);
            map.put((Object)BuiltInLootTables.BASTION_HOGLIN_STABLE.location(), 10);
            map.put((Object)BuiltInLootTables.NETHER_BRIDGE.location(), 10);
        });

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            ResourceLocation name = event.getName();
            LootTable table = event.getTable();
            if (Generation.REPLACE_TEMPLATE) {
                table.removePool("create_dragons_plus:blaze_upgrade_smithing_template");
                if (CDPConfig.features().blazeUpgradeSmithingTemplate.get().booleanValue() && EMPTY_BLAZE_UPGRADE_TEMPLATE.containsKey((Object)name)) {
                    TableInjections.addEmptyBlazeUpgradeTemplate(table, EMPTY_BLAZE_UPGRADE_TEMPLATE.getInt((Object)name));
                }
            }
        }

        private static void addEmptyBlazeUpgradeTemplate(LootTable table, int totalWeight) {
            LootPool.Builder pool = LootPool.lootPool().name(ModItems.EMPTY_BLAZE_UPGRADE_TEMPLATE.getRegisteredName()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.EMPTY_BLAZE_UPGRADE_TEMPLATE).setWeight(1));
            if (totalWeight > 1) {
                pool.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(totalWeight - 1));
            }
            table.addPool(pool.build());
        }
    }
}

