/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.hardcore;

import com.sloobix.nougatadditions.config.Lives;
import com.sloobix.nougatadditions.config.Respawn;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class NADeath {

    @EventBusSubscriber
    public static class RespawnTimer {
        private static final Map<UUID, Integer> playerTimers = new HashMap<UUID, Integer>();
        private static final Map<UUID, Boolean> timerTicking = new HashMap<UUID, Boolean>();

        @SubscribeEvent
        public static void checkTimersOnTick(ServerTickEvent.Post event) {
            for (Map.Entry<UUID, Integer> timer : playerTimers.entrySet()) {
                if (timerTicking.get(timer.getKey()).booleanValue()) {
                    timer.setValue(timer.getValue() - 1);
                }
                ServerPlayer player = event.getServer().getPlayerList().getPlayer(timer.getKey());
                if (timer.getValue() <= 0) {
                    assert (player != null);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = player;
                        Vec3 respawnPos = RespawnTimer.getSafeRespawnPosition(serverPlayer);
                        serverPlayer.teleportTo(Objects.requireNonNull(Objects.requireNonNull(serverPlayer.getServer()).getLevel(serverPlayer.getRespawnDimension())), respawnPos.x, respawnPos.y, respawnPos.z, serverPlayer.getRespawnAngle(), 0.0f);
                        serverPlayer.setHealth(8.0f);
                        serverPlayer.getFoodData().setSaturation(20.0f);
                        serverPlayer.getFoodData().setFoodLevel(20);
                        serverPlayer.setGameMode(GameType.SURVIVAL);
                    }
                    RespawnTimer.removeRespawnTimer(player.getUUID());
                    continue;
                }
                assert (player != null);
            }
        }

        @SubscribeEvent
        private static void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            timerTicking.put(player.getUUID(), false);
        }

        @SubscribeEvent
        private static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
            if (!Lives.hasEntry(event.getEntity().getUUID())) {
                Lives.setLives(event.getEntity().getUUID(), event.getEntity().getName().toString(), Respawn.STARTING_LIVES);
            }
            ServerPlayer player = (ServerPlayer)event.getEntity();
            timerTicking.put(player.getUUID(), true);
        }

        public static void addRespawnTimer(UUID player, int time) {
            playerTimers.put(player, time);
            timerTicking.put(player, true);
        }

        public static void removeRespawnTimer(UUID player) {
            playerTimers.remove(player);
            timerTicking.remove(player);
        }

        public static Vec3 getSafeRespawnPosition(ServerPlayer player) {
            Optional<Vec3> pos;
            BlockState state;
            BlockPos bedPos = player.getRespawnPosition();
            ServerLevel level = player.server.getLevel(player.getRespawnDimension());
            if (bedPos != null && level != null && ((state = level.getBlockState(bedPos)).getBlock() instanceof BedBlock ? (pos = RespawnTimer.findSafeSpotNear(level, bedPos, Respawn.SPAWN_RADIUS, Respawn.VERTICAL_SPAWN_RANGE, true)).isPresent() : state.getBlock() instanceof RespawnAnchorBlock && (pos = RespawnTimer.findSafeSpotNear(level, bedPos, Respawn.SPAWN_RADIUS, Respawn.VERTICAL_SPAWN_RANGE, true)).isPresent())) {
                return pos.get();
            }
            ServerLevel overworld = player.server.getLevel(Level.OVERWORLD);
            assert (overworld != null);
            BlockPos spawn = overworld.getSharedSpawnPos();
            Optional<Vec3> pos2 = RespawnTimer.findSafeSpotNear(overworld, spawn, Respawn.WORLD_SPAWN_RADIUS, 5, false);
            return pos2.get();
        }

        private static Optional<Vec3> findSafeSpotNear(ServerLevel level, BlockPos origin, int radius, int vertical_range, boolean bed_spawn) {
            Vector<BlockPos> validBlocks = new Vector<BlockPos>();
            for (int dy = -vertical_range; dy <= vertical_range; ++dy) {
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos check = origin.offset(dx, dy, dz);
                        BlockPos below = check.below();
                        BlockPos above = check.above();
                        if (level.getBlockState(below).isAir() || level.getBlockState(below).isBurning((BlockGetter)level, below) || !level.getBlockState(check).isAir() || !level.getBlockState(above).isAir()) continue;
                        validBlocks.add(check);
                    }
                }
            }
            if (validBlocks.isEmpty()) {
                return Optional.empty();
            }
            BlockPos top = (BlockPos)validBlocks.firstElement();
            if (bed_spawn) {
                for (BlockPos pos : validBlocks) {
                    if (origin.distManhattan((Vec3i)pos) >= origin.distManhattan((Vec3i)top)) continue;
                    top = pos;
                }
            } else {
                Random r = new Random();
                top = (BlockPos)validBlocks.get(r.nextInt(validBlocks.size()));
            }
            return Optional.of(new Vec3((double)top.getX() + 0.5, (double)top.getY(), (double)top.getZ() + 0.5));
        }
    }

    @EventBusSubscriber
    public static class NALives {
        @SubscribeEvent
        public static void onPlayerDeath(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                MutableComponent message;
                ServerPlayer player = (ServerPlayer)livingEntity;
                event.setCanceled(true);
                NALives.dropPlayerInventory(player);
                player.setGameMode(GameType.SPECTATOR);
                player.setHealth(1.0f);
                player.getInventory().clearContent();
                Lives.die(event.getEntity().getUUID());
                if (Lives.getLives(event.getEntity().getUUID()) > 0) {
                    message = Component.literal((String)player.getName().getString()).withStyle(style -> style.withColor(TextColor.fromRgb((int)0xFF0000))).append((Component)Component.literal((String)" died. Lives left: ").withStyle(style -> style.withColor(TextColor.fromRgb((int)0xFFFFFF))).append((Component)Component.literal((String)("" + Lives.getLives(player.getUUID()))).withStyle(style -> style.withColor(65280))));
                    player.awardStat(Stats.DEATHS);
                    RespawnTimer.addRespawnTimer(player.getUUID(), Respawn.RESPAWN_TIME);
                } else {
                    message = Component.literal((String)player.getName().getString()).withStyle(style -> style.withColor(TextColor.fromRgb((int)0xFF0000))).append((Component)Component.literal((String)" died forever.").withStyle(style -> style.withColor(TextColor.fromRgb((int)0xFFFFFF))));
                }
                Objects.requireNonNull(player.getServer()).getPlayerList().broadcastSystemMessage((Component)message, false);
            }
        }

        private static void dropPlayerInventory(ServerPlayer player) {
            Level level = player.level();
            for (ItemStack stack : player.getInventory().items) {
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)stack);
            }
            for (ItemStack stack : player.getInventory().armor) {
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)stack);
            }
            for (ItemStack stack : player.getInventory().offhand) {
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)stack);
            }
            NALives.dropCuriosItems(player);
        }

        public static void dropCuriosItems(ServerPlayer player) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInv -> {
                Map map = curiosInv.getCurios();
                for (Map.Entry entry : map.entrySet()) {
                    ICurioStacksHandler stackHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler dyn = stackHandler.getStacks();
                    int slots = dyn.getSlots();
                    for (int i = 0; i < slots; ++i) {
                        ItemStack stack = dyn.getStackInSlot(i);
                        if (stack.isEmpty()) continue;
                        ItemEntity drop = new ItemEntity((Level)player.serverLevel(), player.getX(), player.getY(), player.getZ(), stack.copy());
                        player.serverLevel().addFreshEntity((Entity)drop);
                        dyn.setStackInSlot(i, ItemStack.EMPTY);
                    }
                }
            });
        }
    }
}

