/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sloobix.nougatadditions.config.Lives;
import com.sloobix.nougatadditions.config.Respawn;
import com.sloobix.nougatadditions.generals.Debug;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber
public class NACommands {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nougatadditions").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"test").executes(context -> {
            Debug.sendDebugMessage(((CommandSourceStack)context.getSource()).getServer(), "Commands are loaded!");
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nougatadditions").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"setRespawnTime").then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int ticks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            Respawn.setRespawnTime(ticks);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Respawn time is now " + ticks + " ticks")), true);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nougatadditions").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"setStartingLives").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            Respawn.setStartingLives(amount);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Starting Lives are now " + amount)), true);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nougatadditions").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"lives").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(context -> {
            Collection players = GameProfileArgument.getGameProfiles((CommandContext)context, (String)"player");
            for (GameProfile profile : players) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(profile.getName() + " has " + Lives.getLives(profile.getId()) + " lives.")), true);
            }
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nougatadditions").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"setLives").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players = GameProfileArgument.getGameProfiles((CommandContext)context, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            for (GameProfile profile : players) {
                Lives.setLives(profile.getId(), profile.getName(), amount);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set lives of " + profile.getName() + " to " + amount)), true);
            }
            return 1;
        })))));
    }
}

