/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.sloobix.nougatadditions.generals.NAFileWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Durability {
    public static final int DEFAULT_DURABILITY = 69420;
    public static int TOOL_REPAIR_KIT;
    public static int WEAPON_REPAIR_KIT;
    public static int ARMOR_REPAIR_KIT;
    public static int BOW_REPAIR_KIT;
    private static final Gson GSON;
    private static final ExecutorService IO_EXECUTOR;
    private static final Path CONFIG_PATH;

    private static void loadConfig() {
        JsonObject json = new JsonObject();
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TOOL_REPAIR_KIT = json.has("Tool_Repair_Kit") ? json.get("Tool_Repair_Kit").getAsInt() : 69420;
        WEAPON_REPAIR_KIT = json.has("Weapon_Repair_Kit") ? json.get("Weapon_Repair_Kit").getAsInt() : 69420;
        ARMOR_REPAIR_KIT = json.has("Armor_Repair_Kit") ? json.get("Armor_Repair_Kit").getAsInt() : 69420;
        BOW_REPAIR_KIT = json.has("Bow_Repair_Kit") ? json.get("Bow_Repair_Kit").getAsInt() : 69420;
    }

    private static void saveAsync(JsonObject json) {
        IO_EXECUTOR.submit(() -> {
            JsonObject conf = new JsonObject();
            conf.addProperty("Tool_Repair_Kit", (Number)TOOL_REPAIR_KIT);
            conf.addProperty("Weapon_Repair_Kit", (Number)WEAPON_REPAIR_KIT);
            conf.addProperty("Armor_Repair_Kit", (Number)ARMOR_REPAIR_KIT);
            conf.addProperty("Bow_Repair_Kit", (Number)BOW_REPAIR_KIT);
            NAFileWriter.writeToFile(CONFIG_PATH, conf);
        });
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        IO_EXECUTOR = Executors.newSingleThreadExecutor();
        CONFIG_PATH = Path.of("config", "nougatadditions", "durability.json");
        CONFIG_PATH.getParent().toFile().mkdirs();
        if (!CONFIG_PATH.toFile().exists()) {
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                writer.write("{}");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JsonObject conf = new JsonObject();
            conf.addProperty("Tool_Repair_Kit", (Number)10000);
            conf.addProperty("Weapon_Repair_Kit", (Number)8000);
            conf.addProperty("Armor_Repair_Kit", (Number)15000);
            conf.addProperty("Bow_Repair_Kit", (Number)3000);
            NAFileWriter.writeToFile(CONFIG_PATH, conf);
        }
        Durability.loadConfig();
    }
}

