/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sloobix.nougatadditions.generals.NAFileWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Respawn {
    public static final int DEFAULT_TIME = 69;
    public static final int DEFAULT_LIVES = 4;
    public static final int DEFAULT_SPAWN_RADIUS = 2;
    public static final int DEFAULT_VERTICAL_SPAWN_RANGE = 1;
    public static final int DEFAULT_WORLD_SPAWN_RADIUS = 20;
    public static final int DEFAULT_VERTICAL_WORLD_SPAWN_RANGE = 5;
    public static final boolean DEFAULT_LIVES_ENABLED = true;
    public static int RESPAWN_TIME;
    public static int STARTING_LIVES;
    public static int SPAWN_RADIUS;
    public static int VERTICAL_SPAWN_RANGE;
    public static int WORLD_SPAWN_RADIUS;
    public static int VERTICAL_WORLD_SPAWN_RANGE;
    public static boolean LIVES_ENABLED;
    private static final Gson GSON;
    private static final ExecutorService IO_EXECUTOR;
    private static final Path CONFIG_PATH;

    private static void loadConfig() {
        JsonObject json = new JsonObject();
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RESPAWN_TIME = json.has("Respawn_Time") ? json.get("Respawn_Time").getAsInt() : 69;
        STARTING_LIVES = json.has("Starting_Lives") ? json.get("Starting_Lives").getAsInt() : 4;
        SPAWN_RADIUS = json.has("Spawn_radius") ? json.get("Spawn_radius").getAsInt() : 2;
        VERTICAL_SPAWN_RANGE = json.has("Vertical_Spawn_Range") ? json.get("Vertical_Spawn_Range").getAsInt() : 1;
        WORLD_SPAWN_RADIUS = json.has("World_Spawn_Radius") ? json.get("World_Spawn_Radius").getAsInt() : 20;
        VERTICAL_WORLD_SPAWN_RANGE = json.has("Vertical_World_Spawn_Range") ? json.get("Vertical_World_Spawn_Range").getAsInt() : 5;
        LIVES_ENABLED = json.has("Lives_Enabled") ? json.get("Lives_Enabled").getAsBoolean() : true;
    }

    public static void setRespawnTime(int ticks) {
        RESPAWN_TIME = ticks;
        Respawn.saveAsync();
    }

    public static void setStartingLives(int lives) {
        STARTING_LIVES = lives;
        Respawn.saveAsync();
    }

    private static void saveAsync() {
        IO_EXECUTOR.submit(() -> {
            JsonObject conf = new JsonObject();
            conf.addProperty("Respawn_Time", (Number)RESPAWN_TIME);
            conf.addProperty("Starting_Lives", (Number)STARTING_LIVES);
            conf.addProperty("Spawn_radius", (Number)SPAWN_RADIUS);
            conf.addProperty("Vertical_Spawn_Range", (Number)VERTICAL_SPAWN_RANGE);
            conf.addProperty("World_Spawn_Radius", (Number)WORLD_SPAWN_RADIUS);
            conf.addProperty("Vertical_World_Spawn_Range", (Number)VERTICAL_WORLD_SPAWN_RANGE);
            NAFileWriter.writeToFile(CONFIG_PATH, conf);
            try {
                CONFIG_PATH.getParent().toFile().mkdirs();
                try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                    GSON.toJson((JsonElement)conf, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    static {
        SPAWN_RADIUS = 2;
        VERTICAL_SPAWN_RANGE = 1;
        WORLD_SPAWN_RADIUS = 20;
        VERTICAL_WORLD_SPAWN_RANGE = 5;
        LIVES_ENABLED = true;
        GSON = new GsonBuilder().setPrettyPrinting().create();
        IO_EXECUTOR = Executors.newSingleThreadExecutor();
        CONFIG_PATH = Path.of("config", "nougatadditions", "respawn.json");
        CONFIG_PATH.getParent().toFile().mkdirs();
        if (!CONFIG_PATH.toFile().exists()) {
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                writer.write("{}");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JsonObject conf = new JsonObject();
            conf.addProperty("Respawn_Time", (Number)200);
            conf.addProperty("Starting_Lives", (Number)5);
            conf.addProperty("Spawn_radius", (Number)2);
            conf.addProperty("Vertical_Spawn_Range", (Number)1);
            conf.addProperty("World_Spawn_Radius", (Number)20);
            conf.addProperty("Vertical_World_Spawn_Range", (Number)5);
            conf.addProperty("Lives_Enabled", Boolean.valueOf(true));
            NAFileWriter.writeToFile(CONFIG_PATH, conf);
        }
        Respawn.loadConfig();
    }
}

