/*
 * Decompiled with CFR 0.152.
 */
package com.sloobix.nougatadditions.items;

import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public abstract class RepairKit
extends Item {
    public RepairKit(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack tool = player.getItemInHand(hand);
        ItemStack offhand = player.getOffhandItem();
        this.repairTool(tool, offhand, player);
        return InteractionResultHolder.sidedSuccess((Object)tool, (boolean)level.isClientSide);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        assert (player != null);
        if (ModList.get().isLoaded("create") && ModList.get().isLoaded("ponderjs")) {
            if (this.repairDeployer(world, pos, player, context.getItemInHand())) {
                this.repairTool(player.getMainHandItem(), player.getOffhandItem(), player);
            }
        } else {
            this.repairTool(player.getMainHandItem(), player.getOffhandItem(), player);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    private void repairTool(ItemStack tool, ItemStack toRepair, Player player) {
        if (toRepair == null) {
            return;
        }
        if (tool == toRepair) {
            return;
        }
        if (!this.testType(toRepair)) {
            return;
        }
        if (toRepair.isRepairable()) {
            if (toRepair.getDamageValue() >= tool.getMaxDamage() - tool.getDamageValue()) {
                toRepair.setDamageValue(toRepair.getDamageValue() - (tool.getMaxDamage() - tool.getDamageValue()));
                tool.hurtAndBreak(tool.getMaxDamage() - tool.getDamageValue(), (LivingEntity)player, EquipmentSlot.MAINHAND);
            } else {
                tool.hurtAndBreak(toRepair.getDamageValue(), (LivingEntity)player, EquipmentSlot.MAINHAND);
                toRepair.setDamageValue(0);
            }
        }
    }

    private boolean repairDeployer(Level world, BlockPos pos, Player player, ItemStack tool) {
        if (world.getBlockState(pos).getBlock() == BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"deployer"))) {
            if (!player.getOffhandItem().isRepairable()) {
                BlockEntity block = world.getBlockEntity(pos);
                assert (block != null);
                if (block instanceof DeployerBlockEntity) {
                    DeployerBlockEntity deployer = (DeployerBlockEntity)block;
                    ItemStack toRepair = null;
                    if (deployer.getPlayer() != null) {
                        toRepair = deployer.getPlayer().getMainHandItem();
                    }
                    this.repairTool(tool, toRepair, player);
                }
                return true;
            }
            this.repairTool(tool, player.getOffhandItem(), player);
        } else {
            this.repairTool(tool, player.getOffhandItem(), player);
        }
        return false;
    }

    protected abstract boolean testType(ItemStack var1);
}

