/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mindustryunits.init.MindustryUnitsModAttributes;
import mindustryunits.init.MindustryUnitsModBlockEntities;
import mindustryunits.init.MindustryUnitsModBlocks;
import mindustryunits.init.MindustryUnitsModEnchantments;
import mindustryunits.init.MindustryUnitsModEntities;
import mindustryunits.init.MindustryUnitsModFluidTypes;
import mindustryunits.init.MindustryUnitsModFluids;
import mindustryunits.init.MindustryUnitsModItems;
import mindustryunits.init.MindustryUnitsModMenus;
import mindustryunits.init.MindustryUnitsModMobEffects;
import mindustryunits.init.MindustryUnitsModPaintings;
import mindustryunits.init.MindustryUnitsModParticleTypes;
import mindustryunits.init.MindustryUnitsModPotions;
import mindustryunits.init.MindustryUnitsModSounds;
import mindustryunits.init.MindustryUnitsModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mindustry_units")
public class MindustryUnitsMod {
    public static final Logger LOGGER = LogManager.getLogger(MindustryUnitsMod.class);
    public static final String MODID = "mindustry_units";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mindustry_units", "mindustry_units"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public MindustryUnitsMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MindustryUnitsModSounds.REGISTRY.register(bus);
        MindustryUnitsModBlocks.REGISTRY.register(bus);
        MindustryUnitsModBlockEntities.REGISTRY.register(bus);
        MindustryUnitsModItems.REGISTRY.register(bus);
        MindustryUnitsModEntities.REGISTRY.register(bus);
        MindustryUnitsModEnchantments.REGISTRY.register(bus);
        MindustryUnitsModTabs.REGISTRY.register(bus);
        MindustryUnitsModMobEffects.REGISTRY.register(bus);
        MindustryUnitsModPotions.REGISTRY.register(bus);
        MindustryUnitsModPaintings.REGISTRY.register(bus);
        MindustryUnitsModParticleTypes.REGISTRY.register(bus);
        MindustryUnitsModMenus.REGISTRY.register(bus);
        MindustryUnitsModFluids.REGISTRY.register(bus);
        MindustryUnitsModFluidTypes.REGISTRY.register(bus);
        MindustryUnitsModAttributes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

