/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits.entity.model;

import mindustryunits.entity.VolcanicEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class VolcanicModel
extends GeoModel<VolcanicEntity> {
    public ResourceLocation getAnimationResource(VolcanicEntity entity) {
        return new ResourceLocation("mindustry_units", "animations/volcanic.animation.json");
    }

    public ResourceLocation getModelResource(VolcanicEntity entity) {
        return new ResourceLocation("mindustry_units", "geo/volcanic.geo.json");
    }

    public ResourceLocation getTextureResource(VolcanicEntity entity) {
        return new ResourceLocation("mindustry_units", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(VolcanicEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("heead");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

