/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits.entity.model;

import mindustryunits.entity.WarEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WarModel
extends GeoModel<WarEntity> {
    public ResourceLocation getAnimationResource(WarEntity entity) {
        return new ResourceLocation("mindustry_units", "animations/war.animation.json");
    }

    public ResourceLocation getModelResource(WarEntity entity) {
        return new ResourceLocation("mindustry_units", "geo/war.geo.json");
    }

    public ResourceLocation getTextureResource(WarEntity entity) {
        return new ResourceLocation("mindustry_units", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(WarEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("warbase");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

