/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits.entity.model;

import mindustryunits.entity.DespondancyEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class DespondancyModel
extends GeoModel<DespondancyEntity> {
    public ResourceLocation getAnimationResource(DespondancyEntity entity) {
        return new ResourceLocation("mindustry_units", "animations/despondancy.animation.json");
    }

    public ResourceLocation getModelResource(DespondancyEntity entity) {
        return new ResourceLocation("mindustry_units", "geo/despondancy.geo.json");
    }

    public ResourceLocation getTextureResource(DespondancyEntity entity) {
        return new ResourceLocation("mindustry_units", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(DespondancyEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

