/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits.entity.model;

import mindustryunits.entity.DestructionEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class DestructionModel
extends GeoModel<DestructionEntity> {
    public ResourceLocation getAnimationResource(DestructionEntity entity) {
        return new ResourceLocation("mindustry_units", "animations/destruction.animation.json");
    }

    public ResourceLocation getModelResource(DestructionEntity entity) {
        return new ResourceLocation("mindustry_units", "geo/destruction.geo.json");
    }

    public ResourceLocation getTextureResource(DestructionEntity entity) {
        return new ResourceLocation("mindustry_units", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(DestructionEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("destructionbase");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

