/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits.entity.model;

import mindustryunits.entity.MacrophageEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class MacrophageModel
extends GeoModel<MacrophageEntity> {
    public ResourceLocation getAnimationResource(MacrophageEntity entity) {
        return new ResourceLocation("mindustry_units", "animations/macrophage.animation.json");
    }

    public ResourceLocation getModelResource(MacrophageEntity entity) {
        return new ResourceLocation("mindustry_units", "geo/macrophage.geo.json");
    }

    public ResourceLocation getTextureResource(MacrophageEntity entity) {
        return new ResourceLocation("mindustry_units", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(MacrophageEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("macrophagebase");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

