/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mindustryunits.MindustryUnitsMod;
import mindustryunits.procedures.JoinTeam1Procedure;
import mindustryunits.procedures.JoinTeam2Procedure;
import mindustryunits.procedures.JoinTeam3Procedure;
import mindustryunits.procedures.JoinTeam4Procedure;
import mindustryunits.procedures.JoinTeam5Procedure;
import mindustryunits.procedures.JoinTeam6Procedure;
import mindustryunits.procedures.JoinTeam7Procedure;
import mindustryunits.procedures.JoinTeam8Procedure;
import mindustryunits.procedures.JoinTeam9Procedure;
import mindustryunits.procedures.NextTeamGui1Procedure;
import mindustryunits.world.inventory.NewTeamSysMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NewTeamSysButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public NewTeamSysButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public NewTeamSysButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(NewTeamSysButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(NewTeamSysButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            NewTeamSysButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = NewTeamSysMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            NextTeamGui1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            JoinTeam7Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            JoinTeam1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            JoinTeam2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            JoinTeam3Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            JoinTeam4Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            JoinTeam5Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            JoinTeam6Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            JoinTeam8Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 9) {
            JoinTeam9Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MindustryUnitsMod.addNetworkMessage(NewTeamSysButtonMessage.class, NewTeamSysButtonMessage::buffer, NewTeamSysButtonMessage::new, NewTeamSysButtonMessage::handler);
    }
}

