/*
 * Decompiled with CFR 0.152.
 */
package mindustryunits.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mindustryunits.MindustryUnitsMod;
import mindustryunits.procedures.JoinTeam10Procedure;
import mindustryunits.procedures.JoinTeam11Procedure;
import mindustryunits.procedures.JoinTeam12Procedure;
import mindustryunits.procedures.JoinTeam13Procedure;
import mindustryunits.procedures.JoinTeam14Procedure;
import mindustryunits.procedures.JoinTeam15Procedure;
import mindustryunits.procedures.JoinTeam16Procedure;
import mindustryunits.procedures.JoinTeam17Procedure;
import mindustryunits.world.inventory.OtherTeamsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class OtherTeamsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public OtherTeamsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public OtherTeamsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(OtherTeamsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(OtherTeamsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            OtherTeamsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = OtherTeamsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            JoinTeam10Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            JoinTeam11Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            JoinTeam12Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            JoinTeam13Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            JoinTeam14Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            JoinTeam15Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            JoinTeam16Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            JoinTeam17Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MindustryUnitsMod.addNetworkMessage(OtherTeamsButtonMessage.class, OtherTeamsButtonMessage::buffer, OtherTeamsButtonMessage::new, OtherTeamsButtonMessage::handler);
    }
}

