/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.contagion;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.petemc.contagion.Contagion;
import net.petemc.contagion.config.ContagionConfig;
import net.petemc.contagion.effect.ContagionEffects;
import net.petemc.contagion.network.NetworkPayloads;
import org.jetbrains.annotations.NotNull;

public class ContagionClient
implements ClientModInitializer {
    class_2960 hudArmorTexture = class_2960.method_60655((String)"contagion", (String)"textures/hud/contagion_transparent16.png");
    class_2960 contagionHudElement = class_2960.method_60655((String)"contagion", (String)"infection_protection_hud");
    private int hudTextColor;
    private int cachedInfectionProtection = -1;
    private int infectionProtection = -1;
    private int receivedBaseInfectionChance = -1;
    private int receivedMinimumInfectionChance = -1;
    private boolean receivedArmorLowersInfectionChance = false;

    public void onInitializeClient() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (this.receivedBaseInfectionChance != -1 && client.field_1724 != null) {
                this.infectionProtection = this.getEffectiveInfectProtection(client.field_1724);
                if (this.infectionProtection != this.cachedInfectionProtection) {
                    this.cachedInfectionProtection = this.infectionProtection;
                }
                if (!client.field_1724.method_7325() && ContagionConfig.INSTANCE.displayCurrentInfectionProtection) {
                    this.hudArmorTexture = class_2960.method_60655((String)"contagion", (String)"textures/hud/contagion_armor16.png");
                    this.hudTextColor = this.infectionProtection == 100 ? -2838729 : (this.infectionProtection >= 75 ? -12598272 : (this.infectionProtection < 30 ? -43691 : -1));
                } else {
                    this.hudArmorTexture = class_2960.method_60655((String)"contagion", (String)"textures/hud/contagion_transparent16.png");
                    this.hudTextColor = 0;
                }
            }
        });
        HudElementRegistry.addLast((class_2960)this.contagionHudElement, (context, tCounter) -> {
            context.method_25290(class_10799.field_56883, this.hudArmorTexture, context.method_51421() / 2 - 170 + ContagionConfig.INSTANCE.deltaX, context.method_51443() - 19 + ContagionConfig.INSTANCE.deltaY, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_25303(class_310.method_1551().field_1772, this.infectionProtection + "%", context.method_51421() / 2 + 18 - 170 + ContagionConfig.INSTANCE.deltaX, context.method_51443() - 14 + ContagionConfig.INSTANCE.deltaY, this.hudTextColor);
        });
        ClientPlayNetworking.registerGlobalReceiver(NetworkPayloads.hudDataPayload.ID, (payload, context) -> {
            this.receivedBaseInfectionChance = payload.baseInfectionChance();
            this.receivedMinimumInfectionChance = payload.minimumInfectionChance();
            this.receivedArmorLowersInfectionChance = payload.armorLowersInfectionChance();
            context.client().execute(() -> Contagion.LOGGER.info("Data for client HUD-received: {} {} {}:", new Object[]{this.receivedBaseInfectionChance, this.receivedMinimumInfectionChance, this.receivedArmorLowersInfectionChance}));
        });
    }

    private int getEffectiveInfectProtection(@NotNull class_746 clientPlayerEntity) {
        int effectInfectProtection = this.receivedBaseInfectionChance > 100 ? 0 : 100 - this.receivedBaseInfectionChance;
        if (this.receivedArmorLowersInfectionChance) {
            effectInfectProtection += clientPlayerEntity.method_6096() * 3;
        }
        if (effectInfectProtection > 100 - this.receivedMinimumInfectionChance) {
            effectInfectProtection = 100 - this.receivedMinimumInfectionChance;
        }
        if (clientPlayerEntity.method_6059(ContagionEffects.IMMUNITY)) {
            effectInfectProtection = 100;
        }
        return effectInfectProtection;
    }
}

