/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.contagion.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.petemc.contagion.Contagion;

@Config(name="contagion")
public class ContagionConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static ContagionConfig INSTANCE;
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Time in seconds until the infection kills the player | default: 600")
    public int infectionDuration = 600;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Base chance in % an attack will infect the player | default: 80 | range: 0 - 100")
    public int baseInfectionChance = 80;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Minimum infection chance in % (even with armor the chance can not be lower than this minimum) | default: 10 | range: 0 - 100")
    public int minimumInfectionChance = 10;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, wearing armor will lower the infection chance (full Netherite will lower the chance by 60%)")
    public boolean armorLowersInfectionChance = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, random symptoms can occur when infected")
    public boolean enableRandomSymptoms = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Time in seconds a random symptom will last | default: 30")
    public int randomSymptomsDuration = 30;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Chance in % a random symptom can occur when infected | default: 3 | range: 0 - 100")
    public int randomSymptomsChance = 3;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Time in seconds after drinking a cure the player is immune to new infections | default: 120")
    public int immunityDuration = 120;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, drinking milk will cure the player if infected | default: false")
    public boolean milkCuresInfection = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, holding a totem will not prevent the player from dying when the infection timer runs out | default: true")
    public boolean totemPreventsDyingFromInfection = true;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    @Comment(value="[Client] If true, displays the current protection value in the HUD | default: true")
    public boolean displayCurrentInfectionProtection = true;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    @Comment(value="[Client] Move the displayed protection value in the HUD in X-direction | default: 0")
    public int deltaX = 0;
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.Tooltip
    @Comment(value="[Client] Move the displayed protection value in the HUD in Y-direction | default: 0")
    public int deltaY = 0;

    public static void init() {
        AutoConfig.register(ContagionConfig.class, JanksonConfigSerializer::new);
        INSTANCE = (ContagionConfig)AutoConfig.getConfigHolder(ContagionConfig.class).getConfig();
        if (ContagionConfig.INSTANCE.infectionDuration < 0) {
            Contagion.LOGGER.warn("Value for infectionDuration is smaller than 0, using default.");
            ContagionConfig.INSTANCE.infectionDuration = 600;
        }
        if (ContagionConfig.INSTANCE.baseInfectionChance < 0 || ContagionConfig.INSTANCE.baseInfectionChance > 100) {
            Contagion.LOGGER.warn("Value for baseInfectionChance not in range (valid range 0 - 100), using default.");
            ContagionConfig.INSTANCE.baseInfectionChance = 80;
        }
        if (ContagionConfig.INSTANCE.minimumInfectionChance < 0 || ContagionConfig.INSTANCE.minimumInfectionChance > 100) {
            Contagion.LOGGER.warn("Value for minimumInfectionChance not in range (valid range 0 - 100), using default.");
            ContagionConfig.INSTANCE.minimumInfectionChance = 10;
        }
        if (ContagionConfig.INSTANCE.randomSymptomsDuration < 0) {
            Contagion.LOGGER.warn("Value for randomSymptomsDuration is smaller than 0, using default.");
            ContagionConfig.INSTANCE.randomSymptomsDuration = 30;
        }
        if (ContagionConfig.INSTANCE.randomSymptomsChance < 0 || ContagionConfig.INSTANCE.randomSymptomsChance > 100) {
            Contagion.LOGGER.warn("Value for randomSymptomsChance not in range (valid range 0 - 100), using default.");
            ContagionConfig.INSTANCE.randomSymptomsChance = 3;
        }
        if (ContagionConfig.INSTANCE.immunityDuration < 0) {
            Contagion.LOGGER.warn("Value for immunityDuration is smaller than 0, using default.");
            ContagionConfig.INSTANCE.immunityDuration = 120;
        }
    }
}

