/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.InternalRenderingMode;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.iris.IrisCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.AsyncParticleWorkerThread;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.FakeBufferBuilder;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.FakeTesselator;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.FrustumUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.GameUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.TryAndStoreFakeBufferBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.fantastic.ParticleRenderingPhase;
import net.irisshaders.iris.fantastic.PhasedParticleEngine;
import net.minecraft.class_1060;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4668;
import net.minecraft.class_693;
import net.minecraft.class_700;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class AsyncRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Class<?>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static boolean renderAsync = false;
    private static boolean particlePhase = false;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    @NotNull
    public static class_4604 frustum;
    private static Consumer<String> debugConsumer;
    private static CompletableFuture<Void> asyncTask;
    private static boolean irisEarlyOpaquePhase;
    private static int asyncTasksSize;
    private static final ExceptionTracker<Class<? extends class_703>> EXCEPTION_TRACKER;
    private static final Map<class_3999, Pair<class_293.class_5596, class_293>> FORMATS;
    public static final Pair<class_293.class_5596, class_293> EMPTY_FORMAT;
    private static final Map<class_3999, class_287> BUFFER_BUILDERS;
    private static final Map<class_3999, Set<class_703>> SYNC_PARTICLES;

    public static void start(float f, class_4184 camera, int irm) {
        AsyncRenderer.tryDebug();
        switch (irm) {
            case 2: 
            case 4: {
                irisEarlyOpaquePhase = true;
                return;
            }
            case 0: {
                irisEarlyOpaquePhase = ModListHelper.IRIS_LIKE_LOADED;
                return;
            }
            case 5: 
            case 7: {
                irisEarlyOpaquePhase = true;
                break;
            }
            case 3: {
                irisEarlyOpaquePhase = ModListHelper.IRIS_LIKE_LOADED;
                break;
            }
            default: {
                irisEarlyOpaquePhase = false;
            }
        }
        class_310 mc = class_310.method_1551();
        class_3695 profiler = mc.method_16011();
        profiler.method_15405("particles");
        AsyncRenderer.clearSync();
        profiler.method_15396("render_async");
        class_702 particleEngine = mc.field_1713;
        class_1060 textureManager = particleEngine.field_3831;
        ObjectArrayList asyncTasks = new ObjectArrayList(asyncTasksSize);
        for (class_3999 class_39992 : ModListHelper.IS_FORGE ? particleEngine.field_3830.keySet() : class_702.field_17820) {
            class_287 bufferBuilder;
            Queue queue;
            if (class_39992 == class_3999.field_17832 || (queue = (Queue)particleEngine.field_3830.get(class_39992)) == null || queue.isEmpty() || (bufferBuilder = AsyncRenderer.beginBufferBuilder(class_39992, textureManager)) == FakeBufferBuilder.INSTANCE) continue;
            asyncTasks.add((Object)CompletableFuture.runAsync(() -> AsyncRenderer.renderParticles(f, camera, queue, particleRenderType, bufferBuilder), EXECUTOR).exceptionally(AsyncRenderer::renderAsyncExceptionally));
        }
        int size = asyncTasksSize = asyncTasks.size();
        asyncTask = CompletableFuture.allOf((CompletableFuture[])asyncTasks.toArray((Object[])new CompletableFuture[size]));
        profiler.method_15407();
    }

    private static void renderParticles(float f, class_4184 camera, Queue<class_703> particles, class_3999 particleRenderType, class_287 bufferBuilder) {
        class_4604 frustum = AsyncRenderer.frustum;
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        float f2 = f + 1.0f;
        block7: for (class_703 particle : particles) {
            if (!particle.method_3086()) continue;
            ParticleAddon particleAddon = (ParticleAddon)particle;
            switch (particleCullingMode) {
                case AABB: {
                    if (!particleAddon.shouldCull() || FrustumUtil.isVisible(frustum, particle.method_3064())) break;
                    continue block7;
                }
                case SPHERE: {
                    if (!particleAddon.shouldCull() || FrustumUtil.isVisible(frustum, particle)) break;
                    continue block7;
                }
                case ASYNC_AABB: 
                case ASYNC_SPHERE: {
                    if (!particleAddon.shouldCull() || particleAddon.asyncparticles$isVisibleOnScreen()) break;
                    continue block7;
                }
            }
            if (particleAddon.asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            float f3 = particleAddon.asyncparticles$isTicked() ? f : f2;
            try {
                particle.method_3074((class_4588)bufferBuilder, camera, f3);
            }
            catch (Throwable t) {
                AsyncRenderer.onRenderingParticleException(particleRenderType, particle, t);
            }
        }
    }

    private static void onRenderingParticleException(class_3999 particleRenderType, class_703 particle, Throwable t) {
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends class_703> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        ((ParticleAddon)particle).asyncparticles$setRenderSync();
        if (!AsyncRenderer.shouldSync(particleClass)) {
            if (!tolerable) {
                LOGGER.warn("Exception while rendering particle {}, marking as sync", (Object)particle, (Object)t);
            } else {
                LOGGER.warn("Exception {} thrown while rendering particle {} exceeds the threshold, please contact the author: {}", new Object[]{t.getClass().getName(), particle, "https://github.com/Harveykang/AsyncParticles/issues", t});
            }
            AsyncRenderer.markAsSync(particleClass);
        }
        AsyncRenderer.recordSync(particleRenderType, particle);
    }

    private static Void renderAsyncExceptionally(Throwable e) {
        LOGGER.error("Error rendering particle", e);
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && mc.field_1724 != null && mc.method_1560() != null) {
            class_148 reportedException = GameUtil.getReportedException(e);
            throw ExceptionUtil.toThrowDirectly(reportedException == null ? e : reportedException);
        }
        return null;
    }

    public static void endAll(class_4587 poseStack, float f, class_4184 camera, class_765 lightTexture, boolean isAsync) {
        class_310 mc = class_310.method_1551();
        mc.method_16011().method_15405("particles");
        AsyncRenderer.onTranslucent(mc);
        class_4597.class_4598 bufferSource = mc.field_1769.field_20951.method_23000();
        class_702 particleEngine = mc.field_1713;
        if (ModListHelper.IRIS_LIKE_LOADED) {
            ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.EVERYTHING);
        }
        renderAsync = isAsync;
        particlePhase = true;
        particleEngine.method_3049(poseStack, bufferSource, lightTexture, camera, f);
        renderAsync = false;
        particlePhase = false;
        AsyncRenderer.postTranslucent(mc);
    }

    public static boolean isIrisEarlyOpaquePhase() {
        return irisEarlyOpaquePhase;
    }

    public static void irisOpaque(class_4587 poseStack, float f, class_4184 camera, class_765 lightTexture, boolean isAsync) {
        class_310 mc = class_310.method_1551();
        mc.method_16011().method_15405("particles");
        class_761 levelRenderer = mc.field_1769;
        class_4597.class_4598 bufferSource = levelRenderer.field_20951.method_23000();
        class_702 particleEngine = mc.field_1713;
        ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.OPAQUE);
        renderAsync = isAsync;
        particlePhase = true;
        particleEngine.method_3049(poseStack, bufferSource, lightTexture, camera, f);
        renderAsync = false;
        particlePhase = false;
    }

    public static void irisTranslucent(class_4587 poseStack, float f, class_4184 camera, class_765 lightTexture, boolean isAsync) {
        class_310 mc = class_310.method_1551();
        mc.method_16011().method_15405("particles");
        class_761 levelRenderer = mc.field_1769;
        class_4597.class_4598 bufferSource = levelRenderer.field_20951.method_23000();
        AsyncRenderer.onTranslucent(mc);
        class_702 particleEngine = mc.field_1713;
        ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.TRANSLUCENT);
        renderAsync = isAsync;
        particlePhase = true;
        particleEngine.method_3049(poseStack, bufferSource, lightTexture, camera, f);
        renderAsync = false;
        particlePhase = false;
        AsyncRenderer.postTranslucent(mc);
    }

    public static void irisCustom(class_4587 poseStack, float f, class_4184 camera, class_765 lightTexture) {
        class_4587 poseStack2 = null;
        class_310 mc = class_310.method_1551();
        class_702 particleEngine = mc.field_1713;
        class_4604 frustum = AsyncRenderer.frustum;
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        float f2 = f + 1.0f;
        for (Map.Entry entry : particleEngine.field_3830.entrySet()) {
            Queue queue;
            class_3999 particleRenderType = (class_3999)entry.getKey();
            if (particleRenderType == class_3999.field_17832 || (queue = (Queue)entry.getValue()).isEmpty() || FORMATS.get(particleRenderType) != EMPTY_FORMAT) continue;
            if (poseStack2 == null) {
                lightTexture.method_3316();
                RenderSystem.enableDepthTest();
                if (ModListHelper.IS_FORGE) {
                    RenderSystem.activeTexture((int)33986);
                    RenderSystem.activeTexture((int)33984);
                }
                poseStack2 = RenderSystem.getModelViewStack();
                poseStack2.method_22903();
                poseStack2.method_34425(poseStack.method_23760().method_23761());
                RenderSystem.applyModelViewMatrix();
                particlePhase = true;
            }
            RenderSystem.setShader(class_757::method_34546);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            boolean began = false;
            block8: for (class_703 particle : queue) {
                if (!particle.method_3086()) continue;
                ParticleAddon particleAddon = (ParticleAddon)particle;
                switch (particleCullingMode) {
                    case AABB: {
                        if (!particleAddon.shouldCull() || FrustumUtil.isVisible(frustum, particle.method_3064())) break;
                        continue block8;
                    }
                    case SPHERE: {
                        if (!particleAddon.shouldCull() || FrustumUtil.isVisible(frustum, particle)) break;
                        continue block8;
                    }
                    case ASYNC_AABB: 
                    case ASYNC_SPHERE: {
                        if (!particleAddon.shouldCull() || particleAddon.asyncparticles$isVisibleOnScreen()) break;
                        continue block8;
                    }
                }
                if (!began) {
                    particleRenderType.method_18130(bufferBuilder, particleEngine.field_3831);
                    began = true;
                }
                float f3 = particleAddon.asyncparticles$isTicked() ? f : f2;
                try {
                    particle.method_3074((class_4588)bufferBuilder, camera, f3);
                }
                catch (Throwable t) {
                    throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                }
            }
            if (!began) continue;
            particleRenderType.method_18131(tesselator);
        }
        if (poseStack2 != null) {
            particlePhase = false;
            poseStack2.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            lightTexture.method_3315();
        }
    }

    public static boolean isRenderAsync() {
        return renderAsync;
    }

    public static boolean isParticlePhase() {
        return particlePhase;
    }

    private static void waitForAsyncTasks() {
        if (asyncTask != null) {
            asyncTask.join();
            asyncTask = null;
        }
    }

    public static void tryWaitingForAsyncTasks() {
        AsyncRenderer.waitForAsyncTasks();
    }

    public static class_148 constructCrashReport(class_703 particle, class_3999 particleRenderType, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Rendering Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being rendered");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particleRenderType).toString());
        return new class_148(crashReport);
    }

    public static class_287 beginBufferBuilder(class_3999 particleRenderType, class_1060 textureManager) {
        Pair<class_293.class_5596, class_293> pair = AsyncRenderer.getVertexFormatPair(particleRenderType, textureManager);
        if (pair == EMPTY_FORMAT) {
            return FakeBufferBuilder.INSTANCE;
        }
        class_287 builder = BUFFER_BUILDERS.computeIfAbsent(particleRenderType, k -> new class_287(256));
        if (builder.method_22893()) {
            return builder;
        }
        builder.method_1328((class_293.class_5596)pair.first(), (class_293)pair.second());
        return builder;
    }

    @NotNull
    public static Pair<class_293.class_5596, class_293> getVertexFormatPair(class_3999 particleRenderType, class_1060 textureManager) {
        return FORMATS.computeIfAbsent(particleRenderType, k -> AsyncRenderer.computeVertexFormatPair(k, textureManager));
    }

    @NotNull
    private static Pair<class_293.class_5596, class_293> computeVertexFormatPair(class_3999 k, class_1060 textureManager) {
        TryAndStoreFakeBufferBuilder fakeBufferBuilder = new TryAndStoreFakeBufferBuilder();
        k.method_18130((class_287)fakeBufferBuilder, textureManager);
        Exception exception = null;
        try {
            k.method_18131((class_289)FakeTesselator.INSTANCE);
        }
        catch (Exception e) {
            exception = e;
            LOGGER.error("Exception try&store-ing vertex format/mode for particle render type: {}", (Object)k, (Object)e);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.defaultBlendFunc();
        }
        class_293.class_5596 mode = fakeBufferBuilder.getMode();
        class_293 format = fakeBufferBuilder.getFormat();
        if (mode != null && format != null) {
            return Pair.of((Object)mode, (Object)format);
        }
        if (exception != null) {
            throw ExceptionUtil.toThrowDirectly(exception);
        }
        return EMPTY_FORMAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends class_703> aClass) {
        Set<Class<?>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(class_3999 particleRenderType, class_703 particle) {
        Set particles;
        Set set = particles = SYNC_PARTICLES.computeIfAbsent(particleRenderType, k -> Collections.newSetFromMap(new IdentityHashMap()));
        synchronized (set) {
            particles.add(particle);
        }
    }

    public static Set<class_703> getSync(class_3999 particleRenderType) {
        Set<class_703> set = SYNC_PARTICLES.get(particleRenderType);
        return set == null ? Collections.emptySet() : set;
    }

    private static void clearSync() {
        if (!SYNC_PARTICLES.isEmpty()) {
            SYNC_PARTICLES.clear();
        }
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    static void tryDebug() {
        if (debugConsumer != null) {
            Object[] objectArray = new Object[8];
            objectArray[0] = asyncTasksSize;
            objectArray[1] = BUFFER_BUILDERS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() instanceof FakeBufferBuilder ? 0 : ((class_287)e.getValue()).field_1555.capacity()));
            objectArray[2] = ModListHelper.IS_FORGE ? class_310.method_1551().field_1713.field_3830.keySet() : class_702.field_17820;
            objectArray[3] = SYNC_PARTICLES.values().stream().mapToInt(Set::size).sum();
            objectArray[4] = SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList();
            objectArray[5] = FORMATS.entrySet().stream().filter(e -> e.getValue() == EMPTY_FORMAT).map(Map.Entry::getKey).toList();
            objectArray[6] = switch (InternalRenderingMode.getMode()) {
                case 0 -> "SYNC";
                case 1 -> "DELAYED_ASYNC";
                case 2 -> "BEFORE_SYNC";
                case 3 -> "COMPATIBILITY_ASYNC";
                case 4 -> "MIXED_SYNC";
                case 5 -> "BEFORE_ASYNC";
                case 7 -> "MIXED_ASYNC";
                default -> "UNKNOWN";
            };
            objectArray[7] = ModListHelper.IRIS_LIKE_LOADED && IrisApi.getInstance().isShaderPackInUse() ? Optional.ofNullable(IrisCompat.getParticleRenderingSettings()).map(Enum::name).orElse("disabled") : "disabled";
            debugConsumer.accept("[Debug AsyncRenderer]\nasync queue size: %d,\nbuffer capacity: %s,\nrender order: %s,\nsync particle count: %d,\nsync particle types: %s,\nsync particle render types: %s,\nparticle mode: %s,\niris particle mode: %s".formatted(objectArray));
            debugConsumer = null;
        }
    }

    public static void reset() {
        irisEarlyOpaquePhase = false;
        renderAsync = false;
        particlePhase = false;
        try {
            AsyncRenderer.waitForAsyncTasks();
        }
        catch (Exception e) {
            LOGGER.error("Error waiting for particle task while resetting async renderer", (Throwable)e);
        }
        FORMATS.clear();
        AsyncRenderer.clearSync();
        SYNC_PARTICLE_TYPES.clear();
        SYNC_PARTICLE_TYPES.add(class_693.class);
        SYNC_PARTICLE_TYPES.add(class_700.class);
        SYNC_PARTICLE_TYPES.addAll(ConfigHelper.getRenderSyncParticleClasses());
    }

    public static void onTranslucent(class_310 mc) {
        if (mc.field_1769.field_25279 != null) {
            class_276 particlesTarget = mc.field_1769.method_29362();
            particlesTarget.method_1230(class_310.field_1703);
            particlesTarget.method_29329(mc.method_1522());
            class_4668.field_25281.method_23516();
        }
    }

    public static void postTranslucent(class_310 mc) {
        if (mc.field_1769.field_25279 != null) {
            class_4668.field_25281.method_23518();
        }
    }

    static {
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            AsyncRendererThread forkJoinWorkerThread = new AsyncRendererThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
        frustum = new class_4604(new Matrix4f(), new Matrix4f());
        irisEarlyOpaquePhase = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getRenderFailurePerSecondThreshold);
        FORMATS = new ConcurrentHashMap<class_3999, Pair<class_293.class_5596, class_293>>();
        EMPTY_FORMAT = Pair.of(null, null);
        BUFFER_BUILDERS = new IdentityHashMap<class_3999, class_287>();
        SYNC_PARTICLES = Collections.synchronizedMap(new IdentityHashMap());
    }

    public static class AsyncRendererThread
    extends AsyncParticleWorkerThread {
        public AsyncRendererThread(ForkJoinPool forkJoinPool) {
            super(forkJoinPool);
        }

        @Override
        protected void onTermination(Throwable throwable) {
            if (throwable != null) {
                LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
            } else {
                LOGGER.debug("{} shutdown", (Object)this.getName());
            }
            super.onTermination(throwable);
        }
    }
}

