/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ContraptionHandlerClient;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.collision.Matrix3d;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.CollisionType;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.ContraptionAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.ContraptionEntityAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.ContraptionHitResult;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.Create5Util;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.Create6Util;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class CreateUtil {
    public static Collection<WeakReference<AbstractContraptionEntity>> contraptions(class_1936 level) {
        return CreateUtil.loadedContraptions(level).values();
    }

    @Nullable
    public static class_243 collideMotionWithContraptions(class_638 level, class_243 motion, class_238 bounds) {
        Vector3d result = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        class_238 finalBounds = bounds.method_1014(0.1);
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((class_1936)level);
        while (it.hasNext()) {
            class_243 vec3;
            AbstractContraptionEntity entity = it.next();
            if (!((ContraptionEntityAddon)entity).asyncparticles$doParticleCollision() || (vec3 = CreateUtil.collideMotionWithContraption(motion, finalBounds, entity, false)) == null) continue;
            result.set(Math.abs(result.x) < Math.abs(vec3.field_1352) ? result.x : vec3.field_1352, Math.abs(result.y) < Math.abs(vec3.field_1351) ? result.y : vec3.field_1351, Math.abs(result.z) < Math.abs(vec3.field_1350) ? result.z : vec3.field_1350);
        }
        if (result.x == Double.MAX_VALUE || motion.field_1352 == result.x && motion.field_1351 == result.y && motion.field_1350 == result.z) {
            return null;
        }
        return new class_243(result.x, result.y, result.z);
    }

    public static Iterator<AbstractContraptionEntity> forEachContraption(class_1936 level) {
        final Iterator<WeakReference<AbstractContraptionEntity>> iterator = CreateUtil.contraptions(level).iterator();
        return new Iterator<AbstractContraptionEntity>(){
            private AbstractContraptionEntity next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    try {
                        this.next = (AbstractContraptionEntity)((WeakReference)iterator.next()).get();
                        if (this.next == null) {
                            continue;
                        }
                    }
                    catch (ConcurrentModificationException ignored) {
                        this.next = null;
                        return false;
                    }
                    if (!this.next.isAliveOrStale()) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public AbstractContraptionEntity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AbstractContraptionEntity result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super AbstractContraptionEntity> action) {
                while (this.hasNext()) {
                    action.accept((AbstractContraptionEntity)this.next);
                    this.next = null;
                }
            }
        };
    }

    public static class_243 getWorldToLocalTranslation(class_243 entityCenter, class_243 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        class_243 position = ContraptionCollider.worldToLocalPos((class_243)entityCenter, (class_243)anchorVec, (Matrix3d)rotationMatrix, (float)yawOffset);
        return position.method_1020(entityCenter);
    }

    public static CollisionType isCollideWithContraption(class_243 originalMotion, class_238 entityBounds, AbstractContraptionEntity contraptionEntity, boolean estimate) {
        List<class_238> collidableBBs;
        class_238 entityBoundingBox;
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            class_238 bb0 = contraptionEntity.method_5829();
            v0 = bb0.method_1009(0.0, Math.max(Math.max(bb0.method_17939(), bb0.method_17941()) - bb0.method_17940() * 0.3, 0.0), 0.0);
        } else {
            v0 = entityBoundingBox = contraptionEntity.method_5829();
        }
        if (!entityBounds.method_18804(originalMotion).method_994(entityBoundingBox)) {
            return CollisionType.NONE;
        }
        AbstractContraptionEntity.ContraptionRotationState rotation = contraptionEntity.getRotationState();
        Matrix3d rotationMatrix = rotation.asMatrix();
        class_243 center = entityBounds.method_1005();
        float yawOffset = rotation.getYawOffset();
        class_243 anchorVec = contraptionEntity.getAnchorVec();
        class_243 toLocalTranslation = CreateUtil.getWorldToLocalTranslation(center, anchorVec, rotationMatrix, yawOffset);
        class_243 contactPointMotion = contraptionEntity.getContactPointMotion(center);
        class_243 localMotion = rotationMatrix.transform(originalMotion.method_1020(contactPointMotion));
        class_238 localBB = entityBounds.method_997(toLocalTranslation).method_1014(1.0E-7);
        Contraption contraption = contraptionEntity.getContraption();
        Optional collisionShapes = contraption.getSimplifiedEntityColliders();
        if (collisionShapes.isPresent()) {
            collidableBBs = (List<class_238>)collisionShapes.get();
        } else {
            if (estimate) {
                return Math.abs(contactPointMotion.field_1352) + Math.abs(contactPointMotion.field_1351) + Math.abs(contactPointMotion.field_1350) > 0.005 ? CollisionType.MOVING : CollisionType.STATIONARY;
            }
            collidableBBs = ((ContraptionAddon)contraption).asyncparticles$getAabbs();
        }
        class_238 localExpanded = localBB.method_18804(localMotion);
        for (class_238 bb : collidableBBs) {
            if (!localExpanded.method_994(bb)) continue;
            return Math.abs(contactPointMotion.field_1352) + Math.abs(contactPointMotion.field_1351) + Math.abs(contactPointMotion.field_1350) > 0.005 ? CollisionType.MOVING : CollisionType.STATIONARY;
        }
        return CollisionType.NONE;
    }

    @Nullable
    public static class_243 collideMotionWithContraption(class_243 originalMotion, class_238 entityBounds, AbstractContraptionEntity contraptionEntity, boolean estimate) {
        class_243 clippedLocal;
        List<class_238> collidableBBs;
        class_238 entityBoundingBox;
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            class_238 bb0 = contraptionEntity.method_5829();
            v0 = bb0.method_1009(0.0, Math.max(Math.max(bb0.method_17939(), bb0.method_17941()) - bb0.method_17940() * 0.3, 0.0), 0.0);
        } else {
            v0 = entityBoundingBox = contraptionEntity.method_5829();
        }
        if (!entityBounds.method_18804(originalMotion).method_994(entityBoundingBox)) {
            return null;
        }
        AbstractContraptionEntity.ContraptionRotationState rotation = contraptionEntity.getRotationState();
        Matrix3d rotationMatrix = rotation.asMatrix();
        class_243 center = entityBounds.method_1005();
        float yawOffset = rotation.getYawOffset();
        class_243 anchorVec = contraptionEntity.getAnchorVec();
        class_243 toLocalTranslation = CreateUtil.getWorldToLocalTranslation(center, anchorVec, rotationMatrix, yawOffset);
        class_243 contactPointMotion = contraptionEntity.getContactPointMotion(center);
        class_243 localMotion = rotationMatrix.transform(originalMotion.method_1020(contactPointMotion));
        class_238 localBB = entityBounds.method_997(toLocalTranslation).method_1014(1.0E-7);
        Contraption contraption = contraptionEntity.getContraption();
        Optional collisionShapes = contraption.getSimplifiedEntityColliders();
        if (collisionShapes.isPresent()) {
            collidableBBs = (List<class_238>)collisionShapes.get();
        } else {
            if (estimate) {
                return class_243.field_1353;
            }
            collidableBBs = ((ContraptionAddon)contraption).asyncparticles$getAabbs();
        }
        class_243 localCenter = localBB.method_1005();
        double cx = localMotion.field_1352;
        double cy = localMotion.field_1351;
        double cz = localMotion.field_1350;
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        boolean squeezed = false;
        double localXsize = localBB.method_17939();
        double localYsize = localBB.method_17940();
        double localZsize = localBB.method_17941();
        class_238 localExpanded = localBB.method_18804(localMotion);
        for (class_238 bb : collidableBBs) {
            class_243 bbCenter;
            if (!localExpanded.method_994(bb)) continue;
            if (localBB.method_994(bb)) {
                bbCenter = bb.method_1005();
                squeezed = true;
                class_238 intersect = localBB.method_999(bb);
                double intersectXsize = intersect.method_17939();
                double intersectYsize = intersect.method_17940();
                double intersectZsize = intersect.method_17941();
                class_2350.class_2351 squeezedAxis = CreateUtil.getSqueezedAxis(intersectXsize, intersectYsize, intersectZsize);
                switch (squeezedAxis) {
                    case field_11048: {
                        sx = CreateUtil.getSqueezed(localCenter.field_1352, bbCenter.field_1352, intersectXsize, sx);
                        break;
                    }
                    case field_11052: {
                        sy = CreateUtil.getSqueezed(localCenter.field_1351, bbCenter.field_1351, intersectYsize, cy > 0.0 ? cy : sy);
                        break;
                    }
                    case field_11051: {
                        sz = CreateUtil.getSqueezed(localCenter.field_1350, bbCenter.field_1350, intersectZsize, sz);
                    }
                }
                continue;
            }
            if (squeezed) continue;
            bbCenter = bb.method_1005();
            class_243 relative = bbCenter.method_1020(localCenter);
            double halfXsum = (bb.method_17939() + localXsize) * 0.5;
            double halfYsum = (bb.method_17940() + localYsize) * 0.5;
            double halfZsum = (bb.method_17941() + localZsize) * 0.5;
            class_2350.class_2351 collidedAxis = CreateUtil.getCollideAxis(halfXsum, halfYsum, halfZsum, relative);
            switch (collidedAxis) {
                case field_11048: {
                    cx = CreateUtil.getCollided(relative.field_1352, halfXsum, cx);
                    break;
                }
                case field_11052: {
                    cy = CreateUtil.getCollided(relative.field_1351, halfYsum, cy);
                    break;
                }
                case field_11051: {
                    cz = CreateUtil.getCollided(relative.field_1350, halfZsum, cz);
                }
            }
        }
        if (squeezed) {
            clippedLocal = new class_243(sx, sy, sz);
        } else {
            clippedLocal = new class_243(cx, cy, cz);
            if (localMotion.equals((Object)clippedLocal)) {
                return null;
            }
        }
        class_243 clipped = rotationMatrix.transpose().transform(clippedLocal);
        double x = Math.signum(contactPointMotion.field_1352) != Math.signum(originalMotion.field_1352) || Math.abs(clipped.field_1352) < Math.abs(contactPointMotion.field_1352) ? contactPointMotion.field_1352 * 3.0 : contactPointMotion.field_1352;
        double y = Math.signum(contactPointMotion.field_1351) != Math.signum(originalMotion.field_1351) || Math.abs(clipped.field_1351) < Math.abs(contactPointMotion.field_1351) ? contactPointMotion.field_1351 * 3.0 : contactPointMotion.field_1351;
        double z = Math.signum(contactPointMotion.field_1350) != Math.signum(originalMotion.field_1350) || Math.abs(clipped.field_1350) < Math.abs(contactPointMotion.field_1350) ? contactPointMotion.field_1350 * 3.0 : contactPointMotion.field_1350;
        return clipped.method_1031(x, y, z);
    }

    private static double getCollided(double relative, double halfXsum, double mx) {
        double dx;
        double d = dx = relative > 0.0 ? relative - halfXsum : relative + halfXsum;
        if (Math.abs(mx) > Math.abs(dx)) {
            mx = dx;
        }
        return mx;
    }

    private static double getSqueezed(double localCenter, double bbCenter, double intersectSize, double currentSqueezed) {
        double diff = localCenter - bbCenter;
        double halfIntersectSize = intersectSize * 0.5;
        if (diff < -halfIntersectSize) {
            return Math.min(currentSqueezed, -halfIntersectSize - diff);
        }
        if (diff > halfIntersectSize) {
            return Math.max(currentSqueezed, halfIntersectSize - diff);
        }
        return currentSqueezed;
    }

    private static class_2350.class_2351 getSqueezedAxis(double xsize, double ysize, double zsize) {
        if (xsize < ysize) {
            if (xsize < zsize) {
                return class_2350.class_2351.field_11048;
            }
            return class_2350.class_2351.field_11051;
        }
        if (ysize < zsize) {
            return class_2350.class_2351.field_11052;
        }
        return class_2350.class_2351.field_11051;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2350.class_2351 getCollideAxis(double halfXsum, double halfYsum, double halfZsum, class_243 relative) {
        double sx = halfXsum - Math.abs(relative.field_1352);
        double sy = halfYsum - Math.abs(relative.field_1351);
        double sz = halfZsum - Math.abs(relative.field_1350);
        if (sx < sy) {
            if (sx < sz) {
                return class_2350.class_2351.field_11048;
            }
            return class_2350.class_2351.field_11051;
        }
        if (sy < sz) {
            return class_2350.class_2351.field_11052;
        }
        return class_2350.class_2351.field_11051;
    }

    public static Map<Integer, WeakReference<AbstractContraptionEntity>> loadedContraptions(class_1936 level) {
        return ModListHelper.IS_LEGACY_CREATE ? Create5Util.loadedContraptions(level) : Create6Util.loadedContraptions(level);
    }

    public static boolean isUnderContraption(class_638 level, double x, double y, double z, double size) {
        class_238 bounds = new class_238(x - size, y - size, z - size, x + size, y + size, z + size);
        return CollisionType.NONE != CreateUtil.isCollideWithContraption(level, new class_243(0.0, Math.max(16.0, (double)level.method_31600() - y), 0.0), bounds);
    }

    public static boolean isUnderContraption(class_638 level, class_243 pos, double size) {
        class_238 bounds = new class_238(pos.field_1352 - size, pos.field_1351 - size, pos.field_1350 - size, pos.field_1352 + size, pos.field_1351 + size, pos.field_1350 + size);
        return CollisionType.NONE != CreateUtil.isCollideWithContraption(level, new class_243(0.0, Math.max(16.0, (double)level.method_31600() - pos.field_1351), 0.0), bounds);
    }

    public static CollisionType isCollideWithContraption(class_638 level, class_243 motion, class_238 bb) {
        return CreateUtil.isCollideWithContraption(level, motion, bb, true);
    }

    public static CollisionType isCollideWithContraption(class_638 level, class_243 motion, class_238 bb, boolean estimate) {
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((class_1936)level);
        while (it.hasNext()) {
            AbstractContraptionEntity contraptionEntity = it.next();
            CollisionType collisionType = CreateUtil.isCollideWithContraption(motion, bb, contraptionEntity, estimate);
            if (collisionType == CollisionType.NONE) continue;
            return collisionType;
        }
        return CollisionType.NONE;
    }

    @Nullable
    public static class_243 getContraptionDeltaMovement(class_1297 entity) {
        class_1297 rootEntity = entity.method_5668();
        if (rootEntity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ace = (AbstractContraptionEntity)rootEntity;
            return ace.getContactPointMotion(entity.method_19538());
        }
        Iterator<AbstractContraptionEntity> iterator = CreateUtil.forEachContraption((class_1936)rootEntity.method_37908());
        while (iterator.hasNext()) {
            AbstractContraptionEntity contraptionEntity = iterator.next();
            if (!contraptionEntity.collidingEntities.containsKey(rootEntity)) continue;
            return contraptionEntity.getContactPointMotion(entity.method_19538());
        }
        return null;
    }

    public static class_3965 clip(class_638 level, class_243 start, class_243 end) {
        double shortestDistance = Double.MAX_VALUE;
        class_3965 hitResult = null;
        class_243 hit = null;
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((class_1936)level);
        while (it.hasNext()) {
            AbstractContraptionEntity entity = it.next();
            class_3965 hitResult1 = ContraptionHandlerClient.rayTraceContraption((class_243)start, (class_243)end, (AbstractContraptionEntity)entity);
            if (hitResult1 == null || hitResult1.method_17783() == class_239.class_240.field_1333) continue;
            class_243 hit1 = entity.toGlobalVector(hitResult1.method_17784(), 1.0f);
            double hitDiff = start.field_1351 - hit1.field_1351;
            if (!(shortestDistance > hitDiff)) continue;
            hitResult = hitResult1;
            hit = hit1;
        }
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return new class_3965(hit, hitResult.method_17780(), class_2338.method_49638(hit), hitResult.method_17781());
    }

    @Nullable
    public static ContraptionHitResult clipWithContactPointMotion(class_638 level, class_243 start, class_243 end) {
        double shortestDistance = Double.MAX_VALUE;
        class_3965 hitResult = null;
        class_243 hit = null;
        AbstractContraptionEntity entity = null;
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((class_1936)level);
        while (it.hasNext()) {
            class_3965 hitResult1;
            class_238 entity1Bb;
            class_238 class_2382;
            AbstractContraptionEntity entity1 = it.next();
            if (entity1 instanceof CarriageContraptionEntity) {
                class_238 bb0 = entity1.method_5829();
                class_2382 = bb0.method_1009(0.0, Math.max(Math.max(bb0.method_17939(), bb0.method_17941()) - bb0.method_17940() * 0.3, 0.0), 0.0);
            } else {
                class_2382 = entity1.method_5829();
            }
            if (!(entity1Bb = class_2382).method_993(start, end) || (hitResult1 = ContraptionHandlerClient.rayTraceContraption((class_243)start, (class_243)end, (AbstractContraptionEntity)entity1)) == null) continue;
            class_243 hit1 = entity1.toGlobalVector(hitResult1.method_17784(), 1.0f);
            double hitDiff = start.field_1351 - hit1.field_1351;
            if (!(shortestDistance > hitDiff)) continue;
            hitResult = hitResult1;
            hit = hit1;
            entity = entity1;
        }
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return new ContraptionHitResult(entity.getContactPointMotion(hit), hit, hitResult.method_17780(), class_2338.method_49638(hit), hitResult.method_17781());
    }
}

