/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.coremod;

import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.AsyncParticlesMixinPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.spongepowered.asm.mixin.throwables.MixinError;

public class AsyncParticlesMixinConfig {
    public static final Path MIXIN_CONFIG_FILE = Path.of("config", "asyncparticles", "asyncparticles-mixin.properties");
    public static final int VERSION = 1;
    static String COMMENTS = "safeBlockEntityMap: Boolean. Make 'LevelChunk#blockEntities' thread-safe.\nsafeClassInstanceMultiMap: Boolean. Make 'ClassInstanceMultiMap' thread-safe.\nsafeLegacyRandomSource: Boolean. Make LegacyRandomSource thread-safe.\nparticle$noCulling: A comma-separated list of classes extending 'Particle' that should not be culled.\nparticle$noLightCache: A comma-separated list of classes extending 'Particle' that should not use the light cache.\nparticle$lockRequired: A comma-separated list of classes extending 'Particle' that require a spin lock.\nparticle$lockProvider: A comma-separated list of classes extending 'Particle' that provide a spin lock.\nreplaceRandom: A comma-separated list of classes that require multithreaded random sources.\ncreate$contraptionNoParticleCollision: A comma-separated list of classes extending 'AbstractContraptionEntity' that should not collide with particles.\n";
    static final MixinConfigObj CONFIG;
    private static MixinConfigObj toSaveConfig;

    static void load() throws IOException {
        if (!Files.exists(MIXIN_CONFIG_FILE, new LinkOption[0])) {
            Files.createDirectories(MIXIN_CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.createFile(MIXIN_CONFIG_FILE, new FileAttribute[0]);
            AsyncParticlesMixinConfig.reset();
            return;
        }
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(MIXIN_CONFIG_FILE, new OpenOption[0]);){
            properties.load(is);
        }
        MixinConfigObj configObj = new MixinConfigObj();
        configObj.read(properties);
        configObj = AsyncParticlesMixinConfig.upgrade(configObj.version, configObj);
        configObj.flat();
        AsyncParticlesMixinConfig.save(configObj);
    }

    @Contract
    private static MixinConfigObj upgrade(int ver, MixinConfigObj configObj) {
        return switch (ver) {
            case 1 -> configObj;
            default -> new MixinConfigObj();
        };
    }

    static void save() throws IOException {
        MixinConfigObj configObj = new MixinConfigObj();
        configObj.fold();
        AsyncParticlesMixinConfig.save(configObj);
    }

    static void reset() throws IOException {
        MixinConfigObj configObj = new MixinConfigObj();
        configObj.flat();
        AsyncParticlesMixinConfig.save(configObj);
    }

    static void save(MixinConfigObj configObj) throws IOException {
        configObj.version = 1;
        Properties properties = new Properties();
        configObj.write(properties);
        try (OutputStream os = Files.newOutputStream(MIXIN_CONFIG_FILE, new OpenOption[0]);){
            properties.store(os, COMMENTS);
        }
    }

    static MixinConfigObj getToSaveConfig() {
        return toSaveConfig;
    }

    static {
        AsyncParticlesMixinPlugin.LOGGER.debug("AsyncParticlesMixinConfig initialized.", new Object[0]);
        try {
            AsyncParticlesMixinConfig.load();
        }
        catch (Throwable e) {
            throw new MixinError(e);
        }
        CONFIG = toSaveConfig;
    }

    static class MixinConfigObj {
        private int version = 0;
        private boolean safeClassInstanceMultiMap = ModListHelper.IRONS_SPELLBOOKS_LOADED || ModListHelper.MAKE_BUBBLES_POP_LOADED;
        private boolean safeBlockEntityMap = false;
        private boolean safeLegacyRandomSource = false;
        private Set<String> particle$noCulling = new LinkedHashSet<String>();
        private Set<String> particle$noLightCache;
        private Set<String> particle$lockProvider;
        private Set<String> particle$lockRequired;
        private Set<String> replaceRandom;
        private Set<String> create$contraptionNoParticleCollision;

        MixinConfigObj() {
            this.particle$noCulling.add("pigcart.particlerain.particle.GroundFogParticle");
            this.particle$noCulling.add("com.lowdragmc.photon.client.gameobject.FXObject");
            this.particle$noLightCache = new LinkedHashSet<String>();
            this.particle$noLightCache.add("dev.shadowsoffire.gateways.client.GatewayParticle");
            this.particle$noLightCache.add("com.chailotl.particular.particles.FireflyParticle");
            this.particle$noLightCache.add("com.lowdragmc.photon.client.gameobject.FXObject");
            this.particle$noLightCache.add("net.diebuddies.minecraft.weather.WeatherParticle");
            this.particle$lockProvider = new LinkedHashSet<String>();
            this.particle$lockProvider.add("yesman.epicfight.client.particle.TrailParticle");
            this.particle$lockProvider.add("yesman.epicfight.client.particle.AbstractTrailParticle");
            this.particle$lockProvider.add("com.dfdyz.epicacg.client.particle.BloomTrailParticle");
            this.particle$lockProvider.add("com.brandon3055.draconicevolution.client.render.effect.ExplosionFX");
            this.particle$lockProvider.add("com.brandon3055.draconicevolution.client.render.effect.CrystalFXWireless");
            this.particle$lockProvider.add("com.lowdragmc.photon.client.gameobject.FXObject");
            this.particle$lockRequired = new LinkedHashSet<String>();
            this.particle$lockRequired.add("yesman.epicfight.client.particle.TrailParticle");
            this.particle$lockRequired.add("yesman.epicfight.client.particle.AbstractTrailParticle");
            this.particle$lockRequired.add("com.dfdyz.epicacg.client.particle.BloomTrailParticle");
            this.particle$lockRequired.add("com.brandon3055.draconicevolution.client.render.effect.ExplosionFX");
            this.particle$lockRequired.add("com.brandon3055.draconicevolution.client.render.effect.CrystalFXWireless");
            this.particle$lockRequired.add("com.lowdragmc.photon.client.gameobject.emitter.Emitter");
            this.particle$lockRequired.add("com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleEmitter");
            this.particle$lockRequired.add("com.lowdragmc.photon.client.gameobject.emitter.beam.BeamEmitter");
            this.particle$lockRequired.add("com.lowdragmc.photon.client.gameobject.emitter.trail.TrailEmitter");
            this.particle$lockRequired.add("com.lowdragmc.photon.client.gameobject.FXObject");
            this.replaceRandom = new LinkedHashSet<String>();
            this.replaceRandom.add("appeng.client.render.effects.LightningArcFX");
            this.replaceRandom.add("appeng.client.render.effects.LightningFX");
            this.replaceRandom.add("de.cheaterpaul.fallingleaves.util.LeafUtil");
            this.create$contraptionNoParticleCollision = new LinkedHashSet<String>();
            this.create$contraptionNoParticleCollision.add("rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity");
            this.create$contraptionNoParticleCollision.add("rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption");
        }

        private void fold() {
            this.assertNotGlobal();
            this.safeClassInstanceMultiMap = AsyncParticlesMixinConfig.toSaveConfig.safeClassInstanceMultiMap;
            this.safeBlockEntityMap = AsyncParticlesMixinConfig.toSaveConfig.safeBlockEntityMap;
            this.safeLegacyRandomSource = AsyncParticlesMixinConfig.toSaveConfig.safeLegacyRandomSource;
            this.particle$noCulling = AsyncParticlesMixinConfig.toSaveConfig.particle$noCulling;
            this.particle$noLightCache = AsyncParticlesMixinConfig.toSaveConfig.particle$noLightCache;
            this.particle$lockProvider = AsyncParticlesMixinConfig.toSaveConfig.particle$lockProvider;
            this.particle$lockRequired = AsyncParticlesMixinConfig.toSaveConfig.particle$lockRequired;
            this.replaceRandom = AsyncParticlesMixinConfig.toSaveConfig.replaceRandom;
            this.create$contraptionNoParticleCollision = AsyncParticlesMixinConfig.toSaveConfig.create$contraptionNoParticleCollision;
        }

        private void read(Properties properties) {
            this.assertNotGlobal();
            try {
                this.version = Integer.parseInt(properties.getProperty("version"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            MixinConfigObj defaultConfig = new MixinConfigObj();
            this.safeClassInstanceMultiMap = ModListHelper.IRONS_SPELLBOOKS_LOADED || ModListHelper.MAKE_BUBBLES_POP_LOADED || MixinConfigObj.getBoolean(properties, "safeClassInstanceMultiMap", defaultConfig.safeClassInstanceMultiMap);
            this.safeBlockEntityMap = MixinConfigObj.getBoolean(properties, "safeBlockEntityMap", defaultConfig.safeBlockEntityMap);
            this.safeLegacyRandomSource = MixinConfigObj.getBoolean(properties, "safeLegacyRandomSource", defaultConfig.safeLegacyRandomSource);
            this.particle$noCulling = MixinConfigObj.getSet(properties, "particle$noCulling", defaultConfig.particle$noCulling);
            this.particle$noLightCache = MixinConfigObj.getSet(properties, "particle$noLightCache", defaultConfig.particle$noLightCache);
            this.particle$lockProvider = MixinConfigObj.getSet(properties, "particle$lockProvider", defaultConfig.particle$lockProvider);
            this.particle$lockRequired = MixinConfigObj.getSet(properties, "particle$lockRequired", defaultConfig.particle$lockRequired);
            this.replaceRandom = MixinConfigObj.getSet(properties, "replaceRandom", defaultConfig.replaceRandom);
            this.create$contraptionNoParticleCollision = MixinConfigObj.getSet(properties, "create$contraptionNoParticleCollision", defaultConfig.create$contraptionNoParticleCollision);
        }

        void flat() {
            toSaveConfig = this;
        }

        private void write(Properties properties) {
            properties.setProperty("version", Integer.toString(this.version));
            properties.setProperty("safeClassInstanceMultiMap", Boolean.toString(this.safeClassInstanceMultiMap));
            properties.setProperty("safeBlockEntityMap", Boolean.toString(this.safeBlockEntityMap));
            properties.setProperty("safeLegacyRandomSource", Boolean.toString(this.safeLegacyRandomSource));
            properties.setProperty("particle$noCulling", String.join((CharSequence)",", this.particle$noCulling));
            properties.setProperty("particle$noLightCache", String.join((CharSequence)",", this.particle$noLightCache));
            properties.setProperty("particle$lockProvider", String.join((CharSequence)",", this.particle$lockProvider));
            properties.setProperty("particle$lockRequired", String.join((CharSequence)",", this.particle$lockRequired));
            properties.setProperty("replaceRandom", String.join((CharSequence)",", this.replaceRandom));
            properties.setProperty("create$contraptionNoParticleCollision", String.join((CharSequence)",", this.create$contraptionNoParticleCollision));
        }

        private static Set<String> getSet(Properties properties, String key, Set<String> defaultValue) {
            String value = properties.getProperty(key);
            if (value == null) {
                return defaultValue;
            }
            if ((value = value.replaceAll("[\\s\\u0085\\u2028\\u2029]", "")).endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            String[] split = value.split(",");
            LinkedHashSet<String> set = new LinkedHashSet<String>(defaultValue);
            for (String s : split) {
                if (s.isEmpty()) continue;
                set.add(s);
            }
            return Collections.unmodifiableSet(set);
        }

        private static boolean getBoolean(Properties properties, String key, boolean defaultValue) {
            String bool = properties.getProperty(key);
            if (bool == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(bool);
        }

        private void assertNotGlobal() {
            if (this == toSaveConfig || this == CONFIG) {
                throw new IllegalStateException("Cannot modify global config object");
            }
        }

        @Unmodifiable Set<String> getNoCulling() {
            return Collections.unmodifiableSet(this.particle$noCulling);
        }

        void setNoCulling(Set<String> noCulling) {
            this.assertNotGlobal();
            this.particle$noCulling = noCulling;
        }

        @Unmodifiable Set<String> getNoLightCache() {
            return Collections.unmodifiableSet(this.particle$noLightCache);
        }

        void setNoLightCache(Set<String> noLightCache) {
            this.assertNotGlobal();
            this.particle$noLightCache = noLightCache;
        }

        @Unmodifiable Set<String> getLockProvider() {
            return Collections.unmodifiableSet(this.particle$lockProvider);
        }

        void setLockProvider(Set<String> lockProvider) {
            this.assertNotGlobal();
            this.particle$lockProvider = lockProvider;
        }

        @Unmodifiable Set<String> getLockRequired() {
            return Collections.unmodifiableSet(this.particle$lockRequired);
        }

        void setLockRequired(Set<String> lockRequired) {
            this.assertNotGlobal();
            this.particle$lockRequired = lockRequired;
        }

        @Unmodifiable Set<String> getReplaceRandom() {
            return Collections.unmodifiableSet(this.replaceRandom);
        }

        void setReplaceRandom(Set<String> replaceRandom) {
            this.assertNotGlobal();
            this.replaceRandom = replaceRandom;
        }

        void setSafeLegacyRandomSource(boolean safeLegacyRandomSource) {
            this.assertNotGlobal();
            this.safeLegacyRandomSource = safeLegacyRandomSource;
        }

        public boolean isSafeLegacyRandomSource() {
            return this.safeLegacyRandomSource;
        }

        public boolean isSafeClassInstanceMultiMap() {
            return this.safeClassInstanceMultiMap;
        }

        public void setSafeClassInstanceMultiMap(boolean safeClassInstanceMultiMap) {
            this.assertNotGlobal();
            this.safeClassInstanceMultiMap = ModListHelper.IRONS_SPELLBOOKS_LOADED || ModListHelper.MAKE_BUBBLES_POP_LOADED || safeClassInstanceMultiMap;
        }

        public boolean isSafeBlockEntityMap() {
            return this.safeBlockEntityMap;
        }

        public void setSafeBlockEntityMap(boolean safeBlockEntityMap) {
            this.assertNotGlobal();
            this.safeBlockEntityMap = safeBlockEntityMap;
        }

        @Unmodifiable Set<String> getContraptionNoParticleCollision() {
            return Collections.unmodifiableSet(this.create$contraptionNoParticleCollision);
        }

        void setContraptionNoParticleCollision(Collection<String> contraptionNoParticleCollision) {
            this.assertNotGlobal();
            this.create$contraptionNoParticleCollision = new LinkedHashSet<String>(contraptionNoParticleCollision);
        }
    }
}

