/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat;

import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.iris.IrisCompat;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.RenderingMode;
import net.irisshaders.iris.shaderpack.properties.ParticleRenderingSettings;
import org.jetbrains.annotations.ApiStatus;

public class InternalRenderingMode {
    public static final int DELAYED_ASYNC = 1;
    public static final int COMPATIBILITY_ASYNC = 3;
    public static final int BEFORE_ASYNC = 5;
    public static final int MIXED_ASYNC = 7;
    public static final int SYNC = 0;
    public static final int BEFORE_SYNC = 2;
    public static final int MIXED_SYNC = 4;
    private static int mode = 0;

    @ApiStatus.Internal
    public static int updateInternalMode(RenderingMode renderingMode) {
        if (!ModListHelper.IRIS_LIKE_LOADED) {
            int n = switch (renderingMode) {
                default -> throw new IncompatibleClassChangeError();
                case RenderingMode.SYNCHRONOUSLY -> 0;
                case RenderingMode.DELAYED -> 1;
                case RenderingMode.COMPATIBILITY -> 3;
            };
            mode = n;
            return n;
        }
        int i = renderingMode.ordinal();
        ParticleRenderingSettings settings = IrisCompat.getParticleRenderingSettings();
        if (settings != null) {
            i |= settings.ordinal() + 1 << 2;
        }
        int n = switch (i) {
            case 0, 12 -> 0;
            case 1, 13 -> 1;
            case 2, 14 -> 3;
            case 4 -> 2;
            case 5, 6 -> 5;
            case 8 -> 4;
            case 9, 10 -> 7;
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
        mode = n;
        return n;
    }

    public static int getMode() {
        return mode;
    }

    public static boolean isDelayed() {
        return mode == 1;
    }

    public static boolean isASync() {
        return (mode & 1) != 0;
    }

    public static boolean isSync() {
        return (mode & 1) == 0;
    }

    public static boolean isSync(int irm) {
        return (irm & 1) == 0;
    }
}

