/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2;

import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.VSClientUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.phys.AABB;
import org.valkyrienskies.mod.util.BugFixUtil;

public class VSCompat {
    private static final MethodHandle isCollisionBoxTooBig;

    public static boolean canSpawnWeatherParticle(ClientLevel level, double x, double y, double z) {
        return !VSClientUtils.isUnderShipHeightMap(level, x, y, z, 0.5);
    }

    public static boolean canSpawnWeatherParticle(ClientLevel level, double x, double y, double z, double size) {
        return !VSClientUtils.isUnderShipHeightMap(level, x, y, z, size);
    }

    public static boolean isCollisionBoxTooBig(AABB aabb) {
        if (ModListHelper.IS_LEGACY_VS) {
            return BugFixUtil.INSTANCE.isCollisionBoxToBig(aabb);
        }
        try {
            return isCollisionBoxTooBig.invokeExact(aabb);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        if (ModListHelper.IS_LEGACY_VS) {
            isCollisionBoxTooBig = null;
        } else {
            try {
                Method method = BugFixUtil.INSTANCE.getClass().getMethod("isCollisionBoxTooBig", AABB.class);
                isCollisionBoxTooBig = MethodHandles.lookup().unreflect(method).bindTo(BugFixUtil.INSTANCE);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

