/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.mixin.off_thread_access;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class}, priority=1100)
public abstract class MixinLevelRenderer {
    @WrapMethod(method={"setSectionDirty(IIIZ)V"})
    public void setSectionDirty(int x, int y, int z, boolean reRenderOnMainThread, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{x, y, z, reRenderOnMainThread});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{x, y, z, reRenderOnMainThread}));
        }
    }

    @WrapMethod(method={"setBlockDirty(Lnet/minecraft/core/BlockPos;Z)V"})
    public void setBlockDirty(BlockPos pos, boolean reRenderOnMainThread, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{pos, reRenderOnMainThread});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{pos, reRenderOnMainThread}));
        }
    }

    @WrapMethod(method={"setBlocksDirty"})
    public void setBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{minX, minY, minZ, maxX, maxY, maxZ});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{minX, minY, minZ, maxX, maxY, maxZ}));
        }
    }

    @WrapMethod(method={"setSectionDirtyWithNeighbors"})
    public void setSectionDirtyWithNeighbors(int sectionX, int sectionY, int sectionZ, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{sectionX, sectionY, sectionZ});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{sectionX, sectionY, sectionZ}));
        }
    }

    @WrapMethod(method={"destroyBlockProgress"})
    public void destroyBlockProgress(int breakerId, BlockPos pos, int progress, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{breakerId, pos, progress});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{breakerId, pos, progress}));
        }
    }
}

