/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.WeatherRenderer;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.InternalRenderingMode;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.iris.IrisCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.AsyncParticleWorkerThread;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.FrustumUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.fantastic.ParticleRenderingPhase;
import net.minecraft.class_10209;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_693;
import net.minecraft.class_700;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class AsyncRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Class<? extends class_703>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    @NotNull
    public static class_4604 frustum;
    private static Consumer<String> debugConsumer;
    private static CompletableFuture<Void> particlsTask;
    private static boolean mixedParticleRenderingSetting;
    private static int asyncTasksSize;
    public static boolean particlePhase;
    private static final ExceptionTracker<Class<? extends class_703>> EXCEPTION_TRACKER;
    private static final Map<class_3999, BindingTesselator> BTESSELATORS;
    private static final Map<class_3999, Set<class_703>> SYNC_PARTICLES;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static void begin(float partialTick, class_4184 camera, int irm) {
        AsyncRenderer.tryDebug();
        switch (irm) {
            case 4: {
                mixedParticleRenderingSetting = true;
                return;
            }
            case 0: 
            case 2: {
                mixedParticleRenderingSetting = false;
                return;
            }
            case 7: {
                mixedParticleRenderingSetting = true;
                break;
            }
            default: {
                mixedParticleRenderingSetting = false;
            }
        }
        class_310 mc = class_310.method_1551();
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("begin_particles");
        AsyncRenderer.clearSync();
        class_702 particleEngine = mc.field_1713;
        ObjectArrayList asyncTasks = new ObjectArrayList(asyncTasksSize);
        for (class_3999 class_39992 : ModListHelper.IS_FORGE ? particleEngine.field_3830.keySet() : class_702.field_17820) {
            BindingTesselator bTesselator;
            Queue queue;
            if (class_39992 == class_3999.field_17832 || (queue = (Queue)particleEngine.field_3830.get(class_39992)) == null || queue.isEmpty() || (bTesselator = AsyncRenderer.getBTesselator(class_39992)) == BindingTesselator.EMPTY) continue;
            asyncTasks.add((Object)CompletableFuture.runAsync(() -> AsyncRenderer.renderParticles(partialTick, camera, queue, particleRenderType, bTesselator.begin()), EXECUTOR).exceptionally(AsyncRenderer::renderAsyncExceptionally));
        }
        int size = asyncTasksSize = asyncTasks.size();
        particlsTask = CompletableFuture.allOf((CompletableFuture[])asyncTasks.toArray((Object[])new CompletableFuture[size]));
        profiler.method_15407();
    }

    private static void renderParticles(float f, class_4184 camera, Queue<class_703> particles, class_3999 particleRenderType, class_287 bufferBuilder) {
        class_4604 frustum = AsyncRenderer.frustum;
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        float f2 = f + 1.0f;
        block7: for (class_703 particle : particles) {
            float f3;
            if (!particle.method_3086()) continue;
            ParticleAddon particleAddon = (ParticleAddon)particle;
            switch (particleCullingMode) {
                case AABB: {
                    float f4 = f3 = particleAddon.asyncparticles$isTicked() ? f : f2;
                    if (!particleAddon.asyncparticles$shouldCull() || FrustumUtil.isVisible(frustum, particleAddon.getRenderBoundingBox(f3))) break;
                    continue block7;
                }
                case SPHERE: {
                    if (particleAddon.asyncparticles$shouldCull() && !FrustumUtil.isVisible(frustum, particle)) continue block7;
                    f3 = particleAddon.asyncparticles$isTicked() ? f : f2;
                    break;
                }
                case ASYNC_AABB: 
                case ASYNC_SPHERE: {
                    if (particleAddon.asyncparticles$shouldCull() && !particleAddon.asyncparticles$isVisibleOnScreen()) continue block7;
                    f3 = particleAddon.asyncparticles$isTicked() ? f : f2;
                    break;
                }
                default: {
                    float f5 = f3 = particleAddon.asyncparticles$isTicked() ? f : f2;
                }
            }
            if (particleAddon.asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            try {
                particle.method_3074((class_4588)bufferBuilder, camera, f3);
            }
            catch (Throwable t) {
                AsyncRenderer.onRenderingParticleException(particleRenderType, particle, t);
            }
        }
    }

    private static void onRenderingParticleException(class_3999 particleRenderType, class_703 particle, Throwable t) {
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends class_703> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        ((ParticleAddon)particle).asyncparticles$setRenderSync();
        if (!AsyncRenderer.shouldSync(particleClass)) {
            if (!tolerable) {
                LOGGER.warn("Exception while rendering particle {}, marking as sync", (Object)particle, (Object)t);
            } else {
                LOGGER.warn("Exception {} thrown while rendering particle {} exceeds the threshold, please contact the author: {}", new Object[]{t.getClass().getSimpleName(), particle, "https://github.com/Harveykang/AsyncParticles/issues", t});
            }
            AsyncRenderer.markAsSync(particleClass);
        }
        AsyncRenderer.recordSync(particleRenderType, particle);
    }

    private static Void renderAsyncExceptionally(Throwable e) {
        LOGGER.error("Error rendering particle", e);
        class_310 mc1 = class_310.method_1551();
        if (mc1.field_1687 != null && mc1.field_1724 != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        return null;
    }

    public static void endAll(class_4184 camera, float f, Collection<class_3999> renderOrder) {
        AsyncRenderer.tryWaitingForParticleTask();
        float f2 = f + 1.0f;
        for (class_3999 particleRenderType : renderOrder) {
            class_9801 meshData;
            class_287 builder;
            BindingTesselator tesselator = BTESSELATORS.get(particleRenderType);
            if (tesselator == null || tesselator == BindingTesselator.EMPTY) continue;
            Set<class_703> sync = AsyncRenderer.getSync(particleRenderType);
            if (sync.isEmpty()) {
                builder = tesselator.getBuilder();
                if (builder == null || !builder.field_1556) {
                    continue;
                }
            } else {
                builder = tesselator.begin();
                for (class_703 particle : sync) {
                    if (!particle.method_3086()) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.method_3074((class_4588)builder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            if ((meshData = builder.method_60794()) == null) continue;
            class_1921 renderType = particleRenderType.comp_3341();
            if (renderType.method_60894()) {
                meshData.method_60819(tesselator.buffer, RenderSystem.getProjectionType().method_65045());
            }
            renderType.method_60895(meshData);
        }
    }

    public static void endAll(class_4184 camera, float f, Collection<class_3999> renderOrder, Predicate<class_3999> renderTypePredicate) {
        AsyncRenderer.tryWaitingForParticleTask();
        float f2 = f + 1.0f;
        for (class_3999 particleRenderType : renderOrder) {
            class_9801 meshData;
            class_287 builder;
            BindingTesselator tesselator;
            if (particleRenderType.comp_3341() == null || !renderTypePredicate.test(particleRenderType) || (tesselator = BTESSELATORS.get(particleRenderType)) == null || tesselator == BindingTesselator.EMPTY) continue;
            Set<class_703> sync = AsyncRenderer.getSync(particleRenderType);
            if (sync.isEmpty()) {
                builder = tesselator.getBuilder();
                if (builder == null || !builder.field_1556) {
                    continue;
                }
            } else {
                builder = tesselator.begin();
                for (class_703 particle : sync) {
                    if (!particle.method_3086()) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.method_3074((class_4588)builder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            if ((meshData = builder.method_60794()) == null) continue;
            class_1921 renderType = particleRenderType.comp_3341();
            if (renderType.method_60894()) {
                meshData.method_60819(tesselator.buffer, RenderSystem.getProjectionType().method_65045());
            }
            renderType.method_60895(meshData);
        }
    }

    public static boolean isParticlePhase() {
        return particlePhase;
    }

    private static void waitForParticleTask() {
        if (particlsTask != null) {
            particlsTask.join();
            particlsTask = null;
        }
    }

    private static void tryWaitingForParticleTask() {
        AsyncRenderer.waitForParticleTask();
    }

    public static class_148 constructCrashReport(class_703 particle, class_3999 particleRenderType, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Rendering Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being rendered");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particleRenderType).toString());
        return new class_148(crashReport);
    }

    public static boolean isMixedParticleRendering() {
        return mixedParticleRenderingSetting;
    }

    private static void resetBTesselators() {
        BTESSELATORS.values().forEach(BindingTesselator::clear);
    }

    private static void closeBTesselators() {
        Iterator<BindingTesselator> iterator = BTESSELATORS.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    public static BindingTesselator getBTesselator(class_3999 particleRenderType) {
        return BTESSELATORS.computeIfAbsent(particleRenderType, AsyncRenderer::computeBTesselator);
    }

    @NotNull
    private static BindingTesselator computeBTesselator(class_3999 particleRenderType) {
        class_1921 renderType = particleRenderType.comp_3341();
        if (renderType == null) {
            return BindingTesselator.EMPTY;
        }
        return new BindingTesselator(256, renderType.method_23033(), renderType.method_23031());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends class_703> aClass) {
        Set<Class<? extends class_703>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(class_3999 particleRenderType, class_703 particle) {
        Set particles;
        Set set = particles = SYNC_PARTICLES.computeIfAbsent(particleRenderType, k -> Collections.newSetFromMap(new IdentityHashMap()));
        synchronized (set) {
            particles.add(particle);
        }
    }

    public static Set<class_703> getSync(class_3999 particleRenderType) {
        Set<class_703> set = SYNC_PARTICLES.get(particleRenderType);
        return set == null ? Collections.emptySet() : set;
    }

    private static void clearSync() {
        SYNC_PARTICLES.clear();
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    static void tryDebug() {
        if (debugConsumer != null) {
            Object[] objectArray = new Object[10];
            objectArray[0] = asyncTasksSize;
            objectArray[1] = BTESSELATORS.entrySet().stream().filter(e -> e.getValue() != BindingTesselator.EMPTY).collect(Collectors.toMap(entry -> ((class_3999)entry.getKey()).comp_3340(), e -> ((BindingTesselator)e.getValue()).buffer.field_52083));
            objectArray[2] = (ModListHelper.IS_FORGE ? class_310.method_1551().field_1713.field_3830.keySet() : class_702.field_17820).stream().map(class_3999::comp_3340).toList();
            objectArray[3] = SYNC_PARTICLES.values().stream().mapToInt(Set::size).sum();
            objectArray[4] = SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList();
            objectArray[5] = BTESSELATORS.entrySet().stream().filter(e -> e.getValue() == BindingTesselator.EMPTY).map(p -> ((class_3999)p.getKey()).comp_3340()).toList();
            objectArray[6] = switch (InternalRenderingMode.getMode()) {
                case 0 -> "SYNC";
                case 1 -> "DELAYED_ASYNC";
                case 2 -> "BEFORE_SYNC";
                case 3 -> "COMPATIBILITY_ASYNC";
                case 4 -> "MIXED_SYNC";
                case 5 -> "BEFORE_ASYNC";
                case 7 -> "MIXED_ASYNC";
                default -> "UNKNOWN";
            };
            objectArray[7] = ModListHelper.IRIS_LIKE_LOADED ? IrisCompat.getParticleRenderingSettings().name() : "DISABLED";
            objectArray[8] = WeatherRenderer.rainColumns.length;
            objectArray[9] = WeatherRenderer.snowColumns.length;
            debugConsumer.accept("[Debug AsyncRenderer]\nasync queue size: %d,\nbuffer capacity: %s,\nrender order: %s,\nsync particle count: %d,\nsync particle types: %s,\nsync particle render types: %s,\nparticle mode: %s,\niris particle mode: %s,\nweather column array size(rain|snow): %d|%d".formatted(objectArray));
            debugConsumer = null;
        }
    }

    public static void reset() {
        particlePhase = false;
        try {
            AsyncRenderer.waitForParticleTask();
        }
        catch (Exception e) {
            LOGGER.error("Error waiting for particle task while resetting async renderer", (Throwable)e);
        }
        try {
            WeatherRenderer.waitForWeatherTask();
        }
        catch (Exception e) {
            LOGGER.error("Error waiting for weather task while resetting async renderer", (Throwable)e);
        }
        AsyncRenderer.closeBTesselators();
        AsyncRenderer.clearSync();
        WeatherRenderer.reset();
    }

    public static boolean isTranslucentPhase(Enum<?> phase) {
        return phase == ParticleRenderingPhase.TRANSLUCENT;
    }

    static {
        SYNC_PARTICLE_TYPES.add(class_693.class);
        SYNC_PARTICLE_TYPES.add(class_700.class);
        if (ModListHelper.DUMMMMMMY_LOADED) {
            AsyncRenderer.addSyncByClassName("net.mehvahdjukaar.dummmmmmy.client.DamageNumberParticle");
        }
        if (ModListHelper.FABRIC_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("org.ladysnake.effective.particle.SplashParticle");
        }
        if (ModListHelper.FORGE_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("concerrox.effective.particle.SplashParticle");
        }
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            AsyncRendererThread forkJoinWorkerThread = new AsyncRendererThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
        frustum = new class_4604(new Matrix4f(), new Matrix4f());
        mixedParticleRenderingSetting = false;
        particlePhase = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getRenderFailurePerSecondThreshold);
        BTESSELATORS = new ConcurrentHashMap<class_3999, BindingTesselator>();
        SYNC_PARTICLES = Collections.synchronizedMap(new IdentityHashMap());
    }

    public static class AsyncRendererThread
    extends AsyncParticleWorkerThread {
        public AsyncRendererThread(ForkJoinPool forkJoinPool) {
            super(forkJoinPool);
        }

        @Override
        protected void onTermination(Throwable throwable) {
            if (throwable != null) {
                LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
            } else {
                LOGGER.debug("{} shutdown", (Object)this.getName());
            }
            super.onTermination(throwable);
        }
    }
}

