/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.coremod;

import com.bawnorton.mixinsquared.api.MixinCanceller;
import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import com.bawnorton.mixinsquared.ext.ExtensionRegistrar;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncParticlesClient;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.MixinConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesLockProvider;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesLockRequired;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesNoCulling;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesNoLightCache;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterReplaceRandom;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.cancellers.AsyncParticlesMixinCanceller;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.cancellers.AsyncParticlesMixinMemberCanceller;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.class_adjuster.MixinClassAdjusterRegistrar;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.member_canceller.ExtensionMemberCancelApplication;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.member_canceller.MixinMemberCancellerRegistrar;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.service.MixinService;

public class AsyncParticlesMixinPlugin
implements IMixinConfigPlugin {
    static final ILogger LOGGER = MixinService.getService().getLogger("asyncparticles:plugin");
    private static final int PACKAGE_LENGTH = AsyncParticlesClient.class.getPackage().getName().length() + ".mixin.".length();

    public void onLoad(String mixinPackage) {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        ExtensionRegistrar.register((IExtension)new ExtensionMemberCancelApplication());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesNoCulling());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesNoLightCache());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesLockProvider());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesLockRequired());
        MixinClassAdjusterRegistrar.register(new AdjusterReplaceRandom());
        MixinMemberCancellerRegistrar.register(new AsyncParticlesMixinMemberCanceller());
        MixinCancellerRegistrar.register((MixinCanceller)new AsyncParticlesMixinCanceller());
    }

    public String getRefMapperConfig() {
        return ModListHelper.IS_FORGE ? null : "fabric-asyncparticles-common-refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!ModListHelper.IS_CLIENT) {
            return false;
        }
        String mixinPackageName = mixinClassName.substring(PACKAGE_LENGTH);
        String[] split = mixinPackageName.split("\\.");
        if (split.length == 1) {
            return true;
        }
        return switch (split[0]) {
            case "conditional" -> {
                switch (split[1]) {
                    case "MixinClassInstanceMultiMap": {
                        yield MixinConfigHelper.isSafeClassInstanceMultiMap();
                    }
                    case "MixinLevelChunk_BlockEntityMap": {
                        yield MixinConfigHelper.isSafeBlockEntityMap();
                    }
                    case "MixinLegacyRandomSource": {
                        yield MixinConfigHelper.isSafeLegacyRandomSource();
                    }
                }
                yield true;
            }
            case "fabric" -> {
                if (split.length == 2) {
                    if (!ModListHelper.IS_FORGE) {
                        yield true;
                    }
                    yield false;
                }
                switch (split[1]) {
                    case "particlerain_3": {
                        if (ModListHelper.FABRIC_PARTICLERAIN_LOADED && ModListHelper.versionCheck("particlerain", null, "3.999999")) {
                            yield true;
                        }
                        yield false;
                    }
                    case "effectual": {
                        yield ModListHelper.FABRIC_EFFECTUAL_LOADED;
                    }
                    case "particular": {
                        yield ModListHelper.FABRIC_PARTICULAR_LOADED;
                    }
                    case "vulkanmod": {
                        yield ModListHelper.FABRIC_VULKAN_MOD_LOADED;
                    }
                    case "iris": {
                        yield ModListHelper.FABRIC_IRIS_LOADED;
                    }
                    case "porting_lib_base": {
                        yield ModListHelper.FABRIC_PORTING_LIB_BASE_LOADED;
                    }
                    case "loot_beams_up": {
                        yield ModListHelper.FABRIC_LOOT_BEAMS_UP_LOADED;
                    }
                }
                throw new IllegalArgumentException("Unknown fabric mixin: " + mixinClassName);
            }
            case "fake_renders", "off_thread_access", "tick", "render" -> true;
            case "modernui" -> ModListHelper.MODERN_UI_LOADED;
            case "sodium" -> ModListHelper.SODIUM_LOADED;
            case "sodium_0_6" -> {
                if (ModListHelper.SODIUM_LOADED && ModListHelper.versionCheck("sodium", "0.6", "0.7")) {
                    yield true;
                }
                yield false;
            }
            case "sodium_0_7" -> {
                if (ModListHelper.SODIUM_LOADED && ModListHelper.versionCheck("sodium", "0.6.999999", "0.8")) {
                    yield true;
                }
                yield false;
            }
            case "iris_like" -> ModListHelper.IRIS_LIKE_LOADED;
            case "a_good_place" -> ModListHelper.A_GOOD_PLACE_LOADED;
            case "watut" -> ModListHelper.WATUT_LOADED;
            case "physicsmod" -> ModListHelper.PHYSICSMOD_LOADED;
            case "cloth_config" -> ModListHelper.CLOTH_CONFIG_LOADED;
            case "immediatelyfast" -> ModListHelper.IMMEDIATELY_FAST_LOADED;
            case "figura" -> ModListHelper.FIGURA_LOADED;
            default -> throw new IllegalArgumentException("Unknown mixin: " + mixinClassName);
        };
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

