/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Particle.class})
public abstract class MixinParticle_LightCache
implements LightCachedParticleAddon {
    @Shadow
    @Final
    public ClientLevel level;
    @Shadow
    public double x;
    @Shadow
    public double y;
    @Shadow
    public double z;
    @Unique
    private byte asyncparticles$lightCache = 0;

    @Shadow
    public int getLightColor(float partialTick) {
        throw new AssertionError();
    }

    @WrapMethod(method={"getLightColor"})
    private int wrapGetLightColor(float partialTick, Operation<Integer> original) {
        return this.asyncparticles$isEnabledLightCache() ? LightCachedParticleAddon.decompress(this.asyncparticles$getCompressedLight()) : (Integer)original.call(new Object[]{Float.valueOf(partialTick)});
    }

    @Override
    public void asyncparticles$refresh() {
        int light;
        ClientLevel level = this.level;
        if (level == null) {
            return;
        }
        BlockPos.MutableBlockPos blockPos = ((BlockPos.MutableBlockPos)SHARED_POS.get()).set(this.x, this.y, this.z);
        try {
            light = level.hasChunkAt((BlockPos)blockPos) ? LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockPos) : 0;
        }
        catch (MissingPaletteEntryException ignore) {
            light = 0;
        }
        this.asyncparticles$setLight(light);
    }

    @Override
    public void asyncparticles$setLight(int light) {
        this.asyncparticles$lightCache = LightCachedParticleAddon.compress(light);
    }

    @Override
    public byte asyncparticles$getCompressedLight() {
        return this.asyncparticles$lightCache;
    }

    @Override
    public int asyncparticles$invoke_getLightColor(float partialTick) {
        try {
            return this.getLightColor(partialTick);
        }
        catch (MissingPaletteEntryException ignore) {
            return 0;
        }
    }
}

