/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.config;

import fabric.fun.qu_an.minecraft.asyncparticles.client.config.AsyncParticlesConfig;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.RainEffect;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.TickMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

class LegacyConfigMigrator {
    LegacyConfigMigrator() {
    }

    static boolean migrate() {
        Path legacyConfigFile = Paths.get("config", "asyncparticles.properties");
        if (!Files.exists(legacyConfigFile, new LinkOption[0])) {
            return false;
        }
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(legacyConfigFile, new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException e) {
            return false;
        }
        if (properties.get("migrated") != null) {
            return false;
        }
        AsyncParticlesConfig.ConfigObj defaultConfig = new AsyncParticlesConfig.ConfigObj();
        AsyncParticlesConfig.particle$particleLimit = LegacyConfigMigrator.getInt(properties, "limit", 32768);
        if (AsyncParticlesConfig.particle$particleLimit == 32768) {
            AsyncParticlesConfig.particle$particleLimit = defaultConfig.particle.particleLimit;
        }
        AsyncParticlesConfig.particle$particleLightCache = LegacyConfigMigrator.getBoolean(properties, "particleLightCache", defaultConfig.particle.particleLightCache);
        AsyncParticlesConfig.tick$failPerSecLimit = LegacyConfigMigrator.getInt(properties, "tickFailurePerSecondThreshold", defaultConfig.tick.failPerSecLimit);
        AsyncParticlesConfig.tick$suppressCME = LegacyConfigMigrator.getBoolean(properties, "suppressCME", defaultConfig.tick.suppressCME);
        AsyncParticlesConfig.tick$animationTickMode = !LegacyConfigMigrator.getBoolean(properties, "asyncClientBlockEntityAnimate", defaultConfig.tick.animationTickMode != TickMode.SYNCHRONOUSLY) ? TickMode.SYNCHRONOUSLY : (LegacyConfigMigrator.getBoolean(properties, "forceDoneBlockAnimateTick", defaultConfig.tick.animationTickMode == TickMode.FORCE_COMPLETE) ? TickMode.FORCE_COMPLETE : TickMode.INTERRUPTIBLE);
        AsyncParticlesConfig.tick$particleTickMode = LegacyConfigMigrator.getBoolean(properties, "forceDoneParticleTick", defaultConfig.tick.particleTickMode == TickMode.FORCE_COMPLETE) ? TickMode.FORCE_COMPLETE : defaultConfig.tick.particleTickMode;
        AsyncParticlesConfig.rendering$failPerSecLimit = LegacyConfigMigrator.getInt(properties, "renderFailurePerSecondThreshold", defaultConfig.rendering.failPerSecLimit);
        AsyncParticlesConfig.valkyrienSkies$fixParticleLights = LegacyConfigMigrator.getBoolean(properties, "fixParticleLightOnVsShips", defaultConfig.valkyrienSkies.fixParticleLights);
        AsyncParticlesConfig.valkyrienSkies$rainEffect = LegacyConfigMigrator.getBoolean(properties, "doVsShipRainEffectsIfMoving", defaultConfig.valkyrienSkies.rainEffect == RainEffect.ALWAYS) ? RainEffect.ALWAYS : RainEffect.STATIONARY;
        properties.setProperty("migrated", "");
        try (OutputStream os = Files.newOutputStream(legacyConfigFile, new OpenOption[0]);){
            properties.store(os, null);
        }
        catch (IOException e) {
            return true;
        }
        return true;
    }

    private static int getInt(Properties properties, String key, int defaultValue) {
        String i = properties.getProperty(key);
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        String b = properties.getProperty(key);
        if (b != null) {
            return Boolean.toString(!defaultValue).equalsIgnoreCase(b) != defaultValue;
        }
        return defaultValue;
    }
}

