/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WeatherEffectRenderer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WeatherRenderer {
    private static CompletableFuture<Void> weatherTask;
    static WeatherEffectRenderer.ColumnInstance[] rainColumns;
    static WeatherEffectRenderer.ColumnInstance[] snowColumns;
    @Nullable
    private static BindingTesselator rainBTesselator;
    @Nullable
    private static BindingTesselator snowBTesselator;
    private static boolean weatherEnabled;

    public static void beginWeather(float partialTick, Vec3 cameraPos, int rainDistance, WeatherEffectRenderer weatherRenderer, int ticks) {
        if (!weatherEnabled) {
            WeatherRenderer.waitForWeatherTask();
            return;
        }
        weatherEnabled = false;
        Minecraft mc = Minecraft.getInstance();
        float rainLevel = mc.level.getRainLevel(partialTick);
        if (rainLevel > 0.0f) {
            weatherTask = CompletableFuture.runAsync(() -> {
                ObjectArrayList rainColumns = ObjectArrayList.wrap((Object[])rainColumns, (int)0);
                ObjectArrayList snowColumns = ObjectArrayList.wrap((Object[])snowColumns, (int)0);
                weatherRenderer.collectColumnInstances((Level)mc.level, ticks, partialTick, cameraPos, rainDistance, (List)rainColumns, (List)snowColumns);
                rainColumns = (WeatherEffectRenderer.ColumnInstance[])rainColumns.elements();
                snowColumns = (WeatherEffectRenderer.ColumnInstance[])snowColumns.elements();
                if (!rainColumns.isEmpty()) {
                    if (rainBTesselator == null) {
                        rainBTesselator = new BindingTesselator(1536, VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    weatherRenderer.renderInstances((VertexConsumer)rainBTesselator.begin(), (List)rainColumns, cameraPos, 1.0f, rainDistance, rainLevel);
                }
                if (!snowColumns.isEmpty()) {
                    if (snowBTesselator == null) {
                        snowBTesselator = new BindingTesselator(1536, VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    weatherRenderer.renderInstances((VertexConsumer)snowBTesselator.begin(), (List)snowColumns, cameraPos, 0.8f, rainDistance, rainLevel);
                }
            }, AsyncRenderer.EXECUTOR).exceptionally(throwable -> {
                throw ExceptionUtil.toThrowDirectly(throwable);
            });
        }
    }

    public static void endRain(RenderType renderType) {
        WeatherRenderer.end0(rainBTesselator, renderType);
    }

    public static void endSnow(RenderType renderType) {
        WeatherRenderer.end0(snowBTesselator, renderType);
    }

    private static void end0(@Nullable BindingTesselator tesselator, RenderType renderType) {
        if (tesselator == null) {
            return;
        }
        BufferBuilder builder = tesselator.getBuilder();
        if (builder == null || !builder.building) {
            return;
        }
        MeshData meshData = builder.build();
        if (meshData == null) {
            return;
        }
        if (renderType.sortOnUpload()) {
            meshData.sortQuads(tesselator.buffer, RenderSystem.getProjectionType().vertexSorting());
        }
        renderType.draw(meshData);
    }

    public static void waitForWeatherTask() {
        if (weatherTask != null) {
            weatherTask.join();
            weatherTask = null;
        }
    }

    public static void reset() {
        weatherEnabled = false;
        if (rainBTesselator != null) {
            rainBTesselator.close();
            rainBTesselator = null;
        }
        if (snowBTesselator != null) {
            snowBTesselator.close();
            snowBTesselator = null;
        }
        rainColumns = new WeatherEffectRenderer.ColumnInstance[0];
        snowColumns = new WeatherEffectRenderer.ColumnInstance[0];
    }

    public static boolean shouldRenderRain() {
        BufferBuilder builder;
        WeatherRenderer.waitForWeatherTask();
        return rainBTesselator != null && (builder = rainBTesselator.getBuilder()) != null && builder.building;
    }

    public static boolean shouldRenderSnow() {
        BufferBuilder builder;
        WeatherRenderer.waitForWeatherTask();
        return snowBTesselator != null && (builder = snowBTesselator.getBuilder()) != null && builder.building;
    }

    public static void markWeatherEnabled() {
        weatherEnabled = true;
    }

    static {
        rainColumns = new WeatherEffectRenderer.ColumnInstance[0];
        snowColumns = new WeatherEffectRenderer.ColumnInstance[0];
    }
}

