/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;

public class ParticleVertexBuffer {
    public final int vao;
    public final int vbo;
    private ByteBuffer oldBuffer;
    private int size;
    private boolean mapped = false;

    public ParticleVertexBuffer() {
        this.vao = GL30C.glGenVertexArrays();
        this.vbo = GL15C.glGenBuffers();
    }

    public ParticleVertexBuffer(int vao, int vbo) {
        this.vao = vao;
        this.vbo = vbo;
    }

    public static void unbind() {
        GL30C.glBindVertexArray((int)0);
        GL15C.glBindBuffer((int)34962, (int)0);
    }

    public void bind() {
        GL30C.glBindVertexArray((int)this.vao);
        GL15C.glBindBuffer((int)34962, (int)this.vbo);
    }

    public boolean resize(int size) {
        if (this.size >= size) {
            return false;
        }
        this.resize0(size);
        return true;
    }

    public void resize0(int size) {
        GL15C.glBindBuffer((int)34962, (int)this.vbo);
        GL15C.glBufferData((int)34962, (long)size, (int)35048);
        GL15C.glBindBuffer((int)34962, (int)0);
        this.size = size;
    }

    public ByteBuffer map(int size) {
        if (size > this.size) {
            this.resize(size);
        }
        if (this.mapped) {
            throw new IllegalStateException("Buffer is already mapped");
        }
        GL15C.glBindBuffer((int)34962, (int)this.vbo);
        ByteBuffer oldBuffer = GL30C.glMapBufferRange((int)34962, (long)0L, (long)size, (int)58, (ByteBuffer)this.oldBuffer);
        this.mapped = true;
        GL15C.glBindBuffer((int)34962, (int)0);
        Objects.requireNonNull(oldBuffer);
        this.oldBuffer = oldBuffer;
        return this.oldBuffer;
    }

    public void unmap(int size) {
        if (size > this.size) {
            throw new IllegalArgumentException("Unmapping more bytes than buffer size: " + size + " > " + this.size);
        }
        if (!this.mapped) {
            throw new IllegalStateException("Buffer is not mapped");
        }
        GL15C.glBindBuffer((int)34962, (int)this.vbo);
        GL30C.glFlushMappedBufferRange((int)34962, (long)0L, (long)size);
        GL15C.glUnmapBuffer((int)34962);
        this.mapped = false;
        GL15C.glBindBuffer((int)34962, (int)0);
    }

    public void delete() {
        GL15C.glDeleteBuffers((int)this.vbo);
        GL30C.glDeleteVertexArrays((int)this.vao);
    }

    public int getSize() {
        return this.size;
    }
}

