/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_tick;

import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleGroupAddition;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncRendererThread;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_11938;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_6558;
import net.minecraft.class_703;
import net.minecraft.class_733;
import org.jetbrains.annotations.NotNull;

public class AsyncTickBehavior {
    public static final int THREADS = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static Runnable tickFuture;
    private static Runnable cleanupFuture;
    private static final List<Runnable> tickTasks;
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;

    public static <T extends class_703> void onEvict(T particle) {
        particle.method_34019().ifPresent(limit -> class_310.method_1551().field_1713.method_34022(limit, -1));
        if (particle.method_3086()) {
            particle.method_3085();
        }
    }

    public static void doEmittersRemoveIf(Queue<? extends class_733> queue) {
        if (ConfigHelper.isParallelQueueRemoval()) {
            ((IterationSafeEvictingQueue)queue).parallelRemoveIf(particle -> !particle.method_3086(), ConfigHelper.isParallelQueueEviction(), THREADS, EXECUTOR);
        } else {
            queue.removeIf(particle -> AsyncTickBehavior.shouldRemove((class_703)particle, ConfigHelper.isRemoveIfMissedTick()));
        }
    }

    public static boolean shouldRemove(class_703 particle, boolean removeIfMissedTick) {
        if (!particle.method_3086()) {
            return true;
        }
        ParticleAddon particleAddon = (ParticleAddon)particle;
        if (particleAddon.asyncparticles$isTickSync()) {
            return false;
        }
        if (particleAddon.asyncparticles$isTicked()) {
            particleAddon.asyncparticles$resetTicked();
            return false;
        }
        return removeIfMissedTick;
    }

    public static boolean isCancelled() {
        return false;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof class_6558 || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static class_148 onTickParticleException(class_703 particle, Throwable t) {
        if (ThreadUtil.isOnMainThread()) {
            return AsyncTickBehavior.constructCrashReport(particle, t);
        }
        boolean tolerable = AsyncTickBehavior.isTolerable(t);
        Class<? extends class_703> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return null;
        }
        throw AsyncTickBehavior.constructCrashReport(particle, t);
    }

    public static class_148 constructCrashReport(class_703 particle, Throwable t) {
        while (t instanceof CompletionException || t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof class_148) {
            class_148 re = (class_148)t;
            return re;
        }
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being ticked");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particle.method_74274()).toString());
        return new class_148(crashReport);
    }

    public static void waitTickFuture() {
        if (tickFuture != null) {
            tickFuture.run();
            tickFuture = null;
        }
    }

    public static void waitCleanupFuture() {
        if (cleanupFuture != null) {
            cleanupFuture.run();
            cleanupFuture = null;
        }
    }

    public static void preTick(boolean isTheFirstTick) {
        boolean levelRunning;
        if (isTheFirstTick) {
            AsyncTickBehavior.waitTickFuture();
        }
        class_310 mc = class_310.method_1551();
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (levelRunning) {
            if (cleanupFuture != null) {
                throw new IllegalStateException("cleanupFuture is not null!");
            }
            Collection groups = mc.field_1713.field_3830.values();
            ForkJoinTask[] tasks = new ForkJoinTask[groups.size()];
            int idx = 0;
            for (class_11938 group : groups) {
                if (groups.isEmpty()) continue;
                int n = idx++;
                tasks[n] = EXECUTOR.submit(((ParticleGroupAddition)group)::asyncparticles$cleanUp);
            }
            cleanupFuture = () -> {
                for (ForkJoinTask task : tasks) {
                    if (task == null) break;
                    try {
                        task.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    public static void postTick(boolean isTheLastTick) {
        boolean levelRunning;
        AsyncTickBehavior.waitCleanupFuture();
        class_310 mc = class_310.method_1551();
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (levelRunning) {
            mc.field_1713.method_3057();
            if (!isTheLastTick) {
                tickTasks.forEach(Runnable::run);
            } else {
                ForkJoinTask[] tasks = (ForkJoinTask[])tickTasks.stream().map(EXECUTOR::submit).toArray(ForkJoinTask[]::new);
                tickFuture = () -> {
                    for (ForkJoinTask task : tasks) {
                        if (task == null) break;
                        try {
                            task.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            tickTasks.clear();
        }
    }

    public static void dispatch(Runnable tickParticles) {
        tickTasks.add(tickParticles);
    }

    static {
        tickTasks = new ArrayList<Runnable>();
        AtomicInteger workerCount = new AtomicInteger(1);
        EXECUTOR = new ForkJoinPool(THREADS, forkJoinPool -> {
            AsyncRendererThread forkJoinWorkerThread = new AsyncRendererThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
    }
}

