/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.coremod;

import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.AsyncParticlesMixinPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.spongepowered.asm.mixin.throwables.MixinError;

public class AsyncParticlesMixinConfig {
    public static final Path MIXIN_CONFIG_FILE = Path.of("config", "asyncparticles", "asyncparticles-mixin.properties");
    public static final int VERSION = 2;
    static String COMMENTS = "safeBlockEntityMap: Boolean. Make 'LevelChunk#blockEntities' thread-safe.\nsafeClassInstanceMultiMap: Boolean. Make 'ClassInstanceMultiMap' thread-safe.\nsafeLegacyRandomSource: Boolean. Make LegacyRandomSource thread-safe.\nparticle$noCulling: A comma-separated list of classes extending 'Particle' that should not be culled.\nparticle$noLightCache: A comma-separated list of classes extending 'Particle' that should not use the light cache.\nparticle$lockRequired: A comma-separated list of classes extending 'Particle' that require a spin lock.\nparticle$lockProvider: A comma-separated list of classes extending 'Particle' that provide a spin lock.\nreplaceRandom: A comma-separated list of classes that require multithreaded random sources.\n";
    static final MixinConfigObj CONFIG;
    private static MixinConfigObj toSaveConfig;

    static void load() throws IOException {
        if (!Files.exists(MIXIN_CONFIG_FILE, new LinkOption[0])) {
            Files.createDirectories(MIXIN_CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.createFile(MIXIN_CONFIG_FILE, new FileAttribute[0]);
            AsyncParticlesMixinConfig.reset();
            return;
        }
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(MIXIN_CONFIG_FILE, new OpenOption[0]);){
            properties.load(is);
        }
        MixinConfigObj configObj = new MixinConfigObj();
        configObj.read(properties);
        configObj = AsyncParticlesMixinConfig.upgrade(configObj.version, configObj);
        configObj.flat();
        AsyncParticlesMixinConfig.save(configObj);
    }

    @Contract
    private static MixinConfigObj upgrade(int ver, MixinConfigObj configObj) {
        return switch (ver) {
            case 2 -> configObj;
            default -> new MixinConfigObj();
        };
    }

    static void save() throws IOException {
        MixinConfigObj configObj = new MixinConfigObj();
        configObj.fold();
        AsyncParticlesMixinConfig.save(configObj);
    }

    static void reset() throws IOException {
        MixinConfigObj configObj = new MixinConfigObj();
        configObj.flat();
        AsyncParticlesMixinConfig.save(configObj);
    }

    static void save(MixinConfigObj configObj) throws IOException {
        configObj.version = 2;
        Properties properties = new Properties();
        configObj.write(properties);
        try (OutputStream os = Files.newOutputStream(MIXIN_CONFIG_FILE, new OpenOption[0]);){
            properties.store(os, COMMENTS);
        }
    }

    static MixinConfigObj getToSaveConfig() {
        return toSaveConfig;
    }

    static {
        AsyncParticlesMixinPlugin.LOGGER.debug("AsyncParticlesMixinConfig initialized.", new Object[0]);
        try {
            AsyncParticlesMixinConfig.load();
        }
        catch (Throwable e) {
            throw new MixinError(e);
        }
        CONFIG = toSaveConfig;
    }

    static class MixinConfigObj {
        private int version = 0;
        private boolean safeClassInstanceMultiMap = ModListHelper.MAKE_BUBBLES_POP_LOADED;
        private boolean safeBlockEntityMap = false;
        private boolean safeLegacyRandomSource = false;
        private Set<String> noCulling = new LinkedHashSet<String>();
        private Set<String> noLightCache = new LinkedHashSet<String>();
        private Set<String> lockProvider;
        private Set<String> lockRequired;
        private Set<String> replaceRandom;
        private Set<String> asyncTickableParticleGroups;
        private Set<String> modifyTheFromParticleMethod;

        MixinConfigObj() {
            this.noLightCache.add("com.chailotl.particular.particles.FireflyParticle");
            this.noLightCache.add("net.diebuddies.minecraft.weather.WeatherParticle");
            this.lockProvider = new LinkedHashSet<String>();
            this.lockRequired = new LinkedHashSet<String>();
            this.replaceRandom = new LinkedHashSet<String>();
            this.asyncTickableParticleGroups = new LinkedHashSet<String>();
            this.modifyTheFromParticleMethod = new LinkedHashSet<String>();
        }

        private void fold() {
            this.assertNotGlobal();
            this.safeClassInstanceMultiMap = AsyncParticlesMixinConfig.toSaveConfig.safeClassInstanceMultiMap;
            this.safeBlockEntityMap = AsyncParticlesMixinConfig.toSaveConfig.safeBlockEntityMap;
            this.safeLegacyRandomSource = AsyncParticlesMixinConfig.toSaveConfig.safeLegacyRandomSource;
            this.noCulling = AsyncParticlesMixinConfig.toSaveConfig.noCulling;
            this.noLightCache = AsyncParticlesMixinConfig.toSaveConfig.noLightCache;
            this.lockProvider = AsyncParticlesMixinConfig.toSaveConfig.lockProvider;
            this.lockRequired = AsyncParticlesMixinConfig.toSaveConfig.lockRequired;
            this.replaceRandom = AsyncParticlesMixinConfig.toSaveConfig.replaceRandom;
            this.asyncTickableParticleGroups = AsyncParticlesMixinConfig.toSaveConfig.asyncTickableParticleGroups;
            this.modifyTheFromParticleMethod = AsyncParticlesMixinConfig.toSaveConfig.modifyTheFromParticleMethod;
        }

        private void read(Properties properties) {
            this.assertNotGlobal();
            try {
                this.version = Integer.parseInt(properties.getProperty("version"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            MixinConfigObj defaultConfig = new MixinConfigObj();
            this.safeClassInstanceMultiMap = ModListHelper.MAKE_BUBBLES_POP_LOADED || MixinConfigObj.getBoolean(properties, "safeClassInstanceMultiMap", defaultConfig.safeClassInstanceMultiMap);
            this.safeBlockEntityMap = MixinConfigObj.getBoolean(properties, "safeBlockEntityMap", defaultConfig.safeBlockEntityMap);
            this.safeLegacyRandomSource = MixinConfigObj.getBoolean(properties, "safeLegacyRandomSource", defaultConfig.safeLegacyRandomSource);
            this.noCulling = MixinConfigObj.getSet(properties, "particle$noCulling", defaultConfig.noCulling);
            this.noLightCache = MixinConfigObj.getSet(properties, "particle$noLightCache", defaultConfig.noLightCache);
            this.lockProvider = MixinConfigObj.getSet(properties, "particle$lockProvider", defaultConfig.lockProvider);
            this.lockRequired = MixinConfigObj.getSet(properties, "particle$lockRequired", defaultConfig.lockRequired);
            this.replaceRandom = MixinConfigObj.getSet(properties, "replaceRandom", defaultConfig.replaceRandom);
            this.asyncTickableParticleGroups = MixinConfigObj.getSet(properties, "asyncTick$asyncTickableParticleGroups", defaultConfig.asyncTickableParticleGroups);
            this.modifyTheFromParticleMethod = MixinConfigObj.getSet(properties, "asyncTick$modifyTheFromParticleMethod", defaultConfig.modifyTheFromParticleMethod);
        }

        void flat() {
            toSaveConfig = this;
        }

        private void write(Properties properties) {
            properties.setProperty("version", Integer.toString(this.version));
            properties.setProperty("safeClassInstanceMultiMap", Boolean.toString(this.safeClassInstanceMultiMap));
            properties.setProperty("safeBlockEntityMap", Boolean.toString(this.safeBlockEntityMap));
            properties.setProperty("safeLegacyRandomSource", Boolean.toString(this.safeLegacyRandomSource));
            properties.setProperty("particle$noCulling", String.join((CharSequence)",", this.noCulling));
            properties.setProperty("particle$noLightCache", String.join((CharSequence)",", this.noLightCache));
            properties.setProperty("particle$lockProvider", String.join((CharSequence)",", this.lockProvider));
            properties.setProperty("particle$lockRequired", String.join((CharSequence)",", this.lockRequired));
            properties.setProperty("replaceRandom", String.join((CharSequence)",", this.replaceRandom));
        }

        private static Set<String> getSet(Properties properties, String key, Set<String> defaultValue) {
            String value = properties.getProperty(key);
            if (value == null) {
                return defaultValue;
            }
            if ((value = value.replaceAll("[\\s\\u0085\\u2028\\u2029]", "")).endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            String[] split = value.split(",");
            LinkedHashSet<String> set = new LinkedHashSet<String>(defaultValue);
            for (String s : split) {
                if (s.isEmpty()) continue;
                set.add(s);
            }
            return Collections.unmodifiableSet(set);
        }

        private static boolean getBoolean(Properties properties, String key, boolean defaultValue) {
            String bool = properties.getProperty(key);
            if (bool == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(bool);
        }

        private void assertNotGlobal() {
            if (this == toSaveConfig || this == CONFIG) {
                throw new IllegalStateException("Cannot modify global config object");
            }
        }

        @Unmodifiable Set<String> getNoCulling() {
            return Collections.unmodifiableSet(this.noCulling);
        }

        void setNoCulling(Set<String> noCulling) {
            this.assertNotGlobal();
            this.noCulling = noCulling;
        }

        @Unmodifiable Set<String> getNoLightCache() {
            return Collections.unmodifiableSet(this.noLightCache);
        }

        void setNoLightCache(Set<String> noLightCache) {
            this.assertNotGlobal();
            this.noLightCache = noLightCache;
        }

        @Unmodifiable Set<String> getLockProvider() {
            return Collections.unmodifiableSet(this.lockProvider);
        }

        void setLockProvider(Set<String> lockProvider) {
            this.assertNotGlobal();
            this.lockProvider = lockProvider;
        }

        @Unmodifiable Set<String> getLockRequired() {
            return Collections.unmodifiableSet(this.lockRequired);
        }

        void setLockRequired(Set<String> lockRequired) {
            this.assertNotGlobal();
            this.lockRequired = lockRequired;
        }

        @Unmodifiable Set<String> getReplaceRandom() {
            return Collections.unmodifiableSet(this.replaceRandom);
        }

        void setReplaceRandom(Set<String> replaceRandom) {
            this.assertNotGlobal();
            this.replaceRandom = replaceRandom;
        }

        void setSafeLegacyRandomSource(boolean safeLegacyRandomSource) {
            this.assertNotGlobal();
            this.safeLegacyRandomSource = safeLegacyRandomSource;
        }

        boolean isSafeLegacyRandomSource() {
            return this.safeLegacyRandomSource;
        }

        boolean isSafeClassInstanceMultiMap() {
            return this.safeClassInstanceMultiMap;
        }

        void setSafeClassInstanceMultiMap(boolean safeClassInstanceMultiMap) {
            this.assertNotGlobal();
            this.safeClassInstanceMultiMap = ModListHelper.MAKE_BUBBLES_POP_LOADED || safeClassInstanceMultiMap;
        }

        boolean isSafeBlockEntityMap() {
            return this.safeBlockEntityMap;
        }

        void setSafeBlockEntityMap(boolean safeBlockEntityMap) {
            this.assertNotGlobal();
            this.safeBlockEntityMap = safeBlockEntityMap;
        }

        Collection<String> getAsyncTickableParticleGroups() {
            return this.asyncTickableParticleGroups;
        }

        void setAsyncTickableParticleGroups(Set<String> asyncTickableParticleGroups) {
            this.assertNotGlobal();
            this.asyncTickableParticleGroups = asyncTickableParticleGroups;
        }

        Collection<String> getModifyTheFromParticleMethod() {
            return this.modifyTheFromParticleMethod;
        }

        void setModifyTheFromParticleMethod(Set<String> modifyTheFromParticleMethod) {
            this.assertNotGlobal();
            this.modifyTheFromParticleMethod = modifyTheFromParticleMethod;
        }
    }
}

