/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleGroupAddition;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleVertexStorageAddition;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.SingleQuadParticleLayerAddition;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncParticleRenderState;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncRenderBehavior;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.ParticleLayerAttached;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.MemStackUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ParticleThreadLocal;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.feature.ParticleFeatureRenderer;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class AsyncQuadParticleRenderState
extends QuadParticleRenderState
implements AsyncParticleRenderState {
    private final ParticleGroup<SingleQuadParticle> group;
    private MeshData meshData;
    private ByteBufferBuilder byteBufferBuilder;
    private final Map<SingleQuadParticle.Layer, QuadParticleRenderState.PreparedLayer> preparedLayers = new Reference2ObjectArrayMap();
    private static final ParticleThreadLocal<Quaternionf> QUATERNION_LOCAL = ParticleThreadLocal.withInitial(Quaternionf::new);
    private static final ParticleThreadLocal<Vector3f> VECTOR3F_LOCAL = ParticleThreadLocal.withInitial(Vector3f::new);

    public AsyncQuadParticleRenderState(ParticleGroup<SingleQuadParticle> group) {
        this.group = group;
    }

    public void clear() {
        if (((ParticleGroupAddition)this.group).asyncparticles$getFuture() != null) {
            throw new IllegalStateException("submit() has not been called!");
        }
        this.freeBuffers();
        super.clear();
    }

    public void add(@NotNull SingleQuadParticle.Layer layer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, int r, int s) {
        ParticleLayerAttached attached = ((SingleQuadParticleLayerAddition)layer).asyncparticles$getAttached();
        attached.add(f, g, h, i, j, k, l, m, n, o, p, q, r, s);
    }

    @Override
    public void afterAdd() {
        this.particleCount = ParticleLayerAttached.getParticleCount();
        if (this.particleCount == 0) {
            return;
        }
        this.particles.putAll(ParticleLayerAttached.getParticles());
        int vertexCount = this.particleCount * 4;
        this.byteBufferBuilder = ByteBufferBuilder.exactlySized((int)(vertexCount * DefaultVertexFormat.PARTICLE.getVertexSize()));
        long target = this.byteBufferBuilder.reserve(vertexCount * DefaultVertexFormat.PARTICLE.getVertexSize());
        this.preparedLayers.clear();
        this.renderParticles(target);
        ByteBufferBuilder.Result result = this.byteBufferBuilder.build();
        if (result != null) {
            VertexFormat.IndexType indexType = VertexFormat.IndexType.least((int)vertexCount);
            this.meshData = new MeshData(result, new MeshData.DrawState(DefaultVertexFormat.PARTICLE, vertexCount, VertexFormat.Mode.QUADS.indexCount(vertexCount), VertexFormat.Mode.QUADS, indexType));
        }
    }

    private void renderParticles(long targetAddress) {
        int j = 0;
        try (MemoryStack memoryStack = MemStackUtil.stackPush();){
            long offsetPtr = memoryStack.nmalloc(4);
            MemoryUtil.memPutInt((long)offsetPtr, (int)0);
            for (Map.Entry entry : this.particles.entrySet()) {
                QuadParticleRenderState.Storage storage = (QuadParticleRenderState.Storage)entry.getValue();
                int count = storage.count();
                if (count <= 0) continue;
                storage.forEachParticle((f, g, h, ix, jx, k, l, m, n, o, p, q, r, s) -> {
                    int targetOffset = MemoryUtil.memGetInt((long)offsetPtr);
                    this.renderRotatedQuad(targetAddress + (long)targetOffset, f, g, h, ix, jx, k, l, m, n, o, p, q, r, s);
                    MemoryUtil.memPutInt((long)offsetPtr, (int)(targetOffset + 112));
                });
                this.preparedLayers.put((SingleQuadParticle.Layer)entry.getKey(), new QuadParticleRenderState.PreparedLayer(j, count * 6));
                j += count * 4;
            }
        }
    }

    public void renderParticles2(long targetAddress) {
        ForkJoinTask task;
        Set entries = this.particles.entrySet();
        ArrayList<Future> tasks = new ArrayList<Future>(AsyncRenderBehavior.THREADS);
        int j = 0;
        for (Map.Entry entry : entries) {
            QuadParticleRenderState.Storage storage = (QuadParticleRenderState.Storage)entry.getValue();
            int count = storage.count();
            if (count <= 0) continue;
            int slice = (count + 1023) / 1024;
            for (int i = 0; i < slice; ++i) {
                int start = i * 1024;
                int end = Math.min(start + 1024, count);
                long finalTarget = targetAddress;
                tasks.add(AsyncRenderBehavior.EXECUTOR.submit(() -> {
                    try (MemoryStack memoryStack = MemStackUtil.stackPush();){
                        long offsetPtr = memoryStack.nmalloc(4);
                        MemoryUtil.memPutInt((long)offsetPtr, (int)0);
                        ((ParticleVertexStorageAddition)storage).asyncparticles$slice(start, end).forEachParticle((f, g, h, ix, jx, k, l, m, n, o, p, q, r, s) -> {
                            int targetOffset = MemoryUtil.memGetInt((long)offsetPtr);
                            this.renderRotatedQuad(finalTarget + (long)targetOffset, f, g, h, ix, jx, k, l, m, n, o, p, q, r, s);
                            MemoryUtil.memPutInt((long)offsetPtr, (int)(targetOffset + 112));
                        });
                    }
                }));
                targetAddress += (long)(end - start) * 112L;
            }
            this.preparedLayers.put((SingleQuadParticle.Layer)entry.getKey(), new QuadParticleRenderState.PreparedLayer(j, count * 6));
            j += count * 4;
        }
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext() && (task = (ForkJoinTask)((Object)iterator.next())) != null) {
            task.join();
        }
    }

    protected void renderRotatedQuad(long ptr, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, int r, int s) {
        Quaternionf quaternionf = QUATERNION_LOCAL.get();
        quaternionf.set(i, j, k, l);
        Vector3f vector3f = VECTOR3F_LOCAL.get();
        vector3f.set(1.0f, -1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr, vector3f, o, q, r, s);
        vector3f.set(1.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr += 28L, vector3f, o, p, r, s);
        vector3f.set(-1.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr += 28L, vector3f, n, p, r, s);
        vector3f.set(-1.0f, -1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr += 28L, vector3f, n, q, r, s);
    }

    protected void renderVertex(long ptr, Vector3f vector3f, float l, float m, int n, int o) {
        MemoryUtil.memPutFloat((long)ptr, (float)vector3f.x);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)vector3f.y);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)vector3f.z);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)l);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)m);
        MemoryUtil.memPutByte((long)(ptr += 4L), (byte)((byte)ARGB.red((int)n)));
        MemoryUtil.memPutByte((long)(++ptr), (byte)((byte)ARGB.green((int)n)));
        MemoryUtil.memPutByte((long)(++ptr), (byte)((byte)ARGB.blue((int)n)));
        MemoryUtil.memPutByte((long)(++ptr), (byte)((byte)ARGB.alpha((int)n)));
        MemoryUtil.memPutShort((long)(++ptr), (short)((short)(o & 0xFFFF)));
        MemoryUtil.memPutShort((long)(ptr += 2L), (short)((short)(o >> 16 & 0xFFFF)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public QuadParticleRenderState.PreparedBuffers prepare(ParticleFeatureRenderer.ParticleBufferCache particleBufferCache) {
        if (((ParticleGroupAddition)this.group).asyncparticles$getFuture() != null) {
            throw new IllegalStateException("submit() has not been called!");
        }
        if (this.meshData == null) {
            this.freeBuffers();
            return null;
        }
        try {
            particleBufferCache.write(this.meshData.vertexBuffer());
            RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS).getBuffer(this.meshData.drawState().indexCount());
            GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
            QuadParticleRenderState.PreparedBuffers preparedBuffers = new QuadParticleRenderState.PreparedBuffers(this.meshData.drawState().indexCount(), gpuBufferSlice, this.preparedLayers);
            return preparedBuffers;
        }
        finally {
            this.freeBuffers();
        }
    }

    private void freeBuffers() {
        if (this.byteBufferBuilder != null) {
            this.byteBufferBuilder.close();
            this.byteBufferBuilder = null;
            this.meshData = null;
        }
    }
}

