/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.fabric.AsyncRendererImpl;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.TryAndStoreFakeBufferBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.fantastic.ParticleRenderingPhase;
import net.irisshaders.iris.fantastic.PhasedParticleEngine;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.properties.ParticleRenderingSettings;
import net.minecraft.class_1060;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_4668;
import net.minecraft.class_693;
import net.minecraft.class_700;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class AsyncRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Class<? extends class_703>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    public static boolean renderAsync = false;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    public static class_4604 frustum;
    private static Consumer<String> debugConsumer;
    private static CompletableFuture<Void> asyncTask;
    private static boolean mixedParticleRenderingSetting;
    private static int asyncTasksSize;
    private static final ExceptionTracker<Class<? extends class_703>> EXCEPTION_TRACKER;
    private static final Map<class_3999, BindingTesselator> BTESSELATORS;
    private static final Map<class_3999, Set<class_703>> SYNC_PARTICLES;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static void start(float f, class_4184 camera, boolean isRenderAsync) {
        AsyncRenderer.tryDebug();
        if (!isRenderAsync) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_3695 profiler = mc.method_16011();
        profiler.method_15405("particles");
        AsyncRenderer.clearSync();
        profiler.method_15396("render_async");
        class_702 particleEngine = mc.field_1713;
        class_1060 textureManager = particleEngine.field_3831;
        ObjectArrayList asyncTasks = new ObjectArrayList(asyncTasksSize);
        for (class_3999 class_39992 : ModListHelper.IS_FORGE ? particleEngine.field_3830.keySet() : class_702.field_17820) {
            Queue queue;
            if (class_39992 == class_3999.field_17832 || (queue = (Queue)particleEngine.field_3830.get(class_39992)) == null || queue.isEmpty()) continue;
            BindingTesselator bTesselator = AsyncRenderer.getBTesselator(class_39992, textureManager);
            if (bTesselator.shouldSync) continue;
            asyncTasks.add((Object)CompletableFuture.runAsync(() -> AsyncRenderer.renderParticles(f, camera, queue, particleRenderType, bTesselator.begin()), EXECUTOR).exceptionally(AsyncRenderer::renderAsyncExceptionally));
        }
        int size = asyncTasksSize = asyncTasks.size();
        asyncTask = CompletableFuture.allOf((CompletableFuture[])asyncTasks.toArray((Object[])new CompletableFuture[size]));
        profiler.method_15407();
    }

    private static void renderParticles(float f, class_4184 camera, Queue<class_703> particles, class_3999 particleRenderType, class_287 bufferBuilder) {
        class_4604 frustum = AsyncRenderer.frustum;
        boolean enableCull = ConfigHelper.isCullParticles();
        float f2 = f + 1.0f;
        for (class_703 particle : particles) {
            float f3;
            if (!particle.method_3086()) continue;
            float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            if (enableCull && !frustum.method_23093(((ParticleAddon)particle).getRenderBoundingBox(f3))) continue;
            if (((ParticleAddon)particle).asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            try {
                particle.method_3074((class_4588)bufferBuilder, camera, f3);
            }
            catch (Throwable t) {
                AsyncRenderer.onRenderingParticleException(particleRenderType, particle, t);
            }
        }
    }

    private static void onRenderingParticleException(class_3999 particleRenderType, class_703 particle, Throwable t) {
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends class_703> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        ((ParticleAddon)particle).asyncparticles$setRenderSync();
        if (!AsyncRenderer.shouldSync(particleClass)) {
            if (!tolerable) {
                LOGGER.warn("Exception while rendering particle {}, marking as sync", (Object)particle, (Object)t);
            } else {
                LOGGER.warn("Exception {} thrown while rendering particle {} exceeds the threshold, please contact the author: {}", new Object[]{t.getClass().getSimpleName(), particle, "https://github.com/Harveykang/AsyncParticles/issues", t});
            }
            AsyncRenderer.markAsSync(particleClass);
        }
        AsyncRenderer.recordSync(particleRenderType, particle);
    }

    private static Void renderAsyncExceptionally(Throwable e) {
        LOGGER.error("Error rendering particle", e);
        class_310 mc1 = class_310.method_1551();
        if (mc1.field_1687 != null && mc1.field_1724 != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        return null;
    }

    public static void endAll(float f, class_4184 camera, class_765 lightTexture) {
        class_310 mc = class_310.method_1551();
        mc.method_16011().method_15405("particles");
        class_761 levelRenderer = mc.field_1769;
        if (levelRenderer.field_25279 != null) {
            class_276 particlesTarget = levelRenderer.method_29362();
            particlesTarget.method_1230(class_310.field_1703);
            particlesTarget.method_29329(mc.method_1522());
            class_4668.field_25281.method_23516();
        }
        class_702 particleEngine = mc.field_1713;
        renderAsync = ConfigHelper.isRenderAsync();
        if (ModListHelper.FABRIC_IRIS_LOADED) {
            ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.EVERYTHING);
        }
        particleEngine.method_3049(lightTexture, camera, f);
        renderAsync = false;
        if (levelRenderer.field_25279 != null) {
            class_4668.field_25281.method_23518();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void endOpaque(float f, class_4184 camera, class_765 lightTexture) {
        void var2_2;
        void var1_1;
        AsyncRendererImpl.endOpaque(f, (class_4184)var1_1, (class_765)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void endTranslucent(float f, class_4184 camera, class_765 lightTexture) {
        void var2_2;
        void var1_1;
        AsyncRendererImpl.endTranslucent(f, (class_4184)var1_1, (class_765)var2_2);
    }

    public static boolean isRenderAsync() {
        return renderAsync;
    }

    public static void waitForAsyncTasks() {
        if (asyncTask != null) {
            asyncTask.join();
            asyncTask = null;
        }
    }

    public static void tryWaitForAsyncTasks() {
        AsyncRenderer.waitForAsyncTasks();
    }

    public static class_148 constructCrashReport(class_703 particle, class_3999 particleRenderType, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Rendering Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being rendered");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particleRenderType).toString());
        return new class_148(crashReport);
    }

    public static void captureParticleRenderingSetting() {
        if (ModListHelper.IRIS_LIKE_LOADED) {
            mixedParticleRenderingSetting = Iris.isPackInUseQuick() && AsyncRenderer.getParticleRenderingSettings0() == ParticleRenderingSettings.MIXED;
        }
    }

    public static boolean isMixedParticleRendering() {
        return mixedParticleRenderingSetting;
    }

    private static ParticleRenderingSettings getParticleRenderingSettings0() {
        if (!Iris.isPackInUseQuick()) {
            return ParticleRenderingSettings.UNSET;
        }
        return Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::getParticleRenderingSettings).orElse(ParticleRenderingSettings.MIXED);
    }

    private static void resetBTesselators() {
        BTESSELATORS.values().forEach(BindingTesselator::method_60828);
    }

    private static void closeBTesselators() {
        Iterator<BindingTesselator> iterator = BTESSELATORS.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
            iterator.remove();
        }
    }

    public static BindingTesselator getBTesselator(class_3999 particleRenderType, class_1060 textureManager) {
        return BTESSELATORS.computeIfAbsent(particleRenderType, k -> AsyncRenderer.computeBTesselator(k, textureManager));
    }

    @NotNull
    private static BindingTesselator computeBTesselator(class_3999 particleRenderType, class_1060 textureManager) {
        TryAndStoreFakeBufferBuilder fakeBufferBuilder = new TryAndStoreFakeBufferBuilder();
        class_287 builder = particleRenderType.method_18130((class_289)fakeBufferBuilder, textureManager);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        if (builder == null) {
            return BindingTesselator.EMPTY;
        }
        class_293.class_5596 mode = fakeBufferBuilder.getMode();
        class_293 format = fakeBufferBuilder.getFormat();
        if (mode == null || format == null) {
            return BindingTesselator.EMPTY;
        }
        return new BindingTesselator(256, mode, format, particleRenderType == class_3999.field_17831);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends class_703> aClass) {
        Set<Class<? extends class_703>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(class_3999 particleRenderType, class_703 particle) {
        Set particles;
        Set set = particles = SYNC_PARTICLES.computeIfAbsent(particleRenderType, k -> Collections.newSetFromMap(new IdentityHashMap()));
        synchronized (set) {
            particles.add(particle);
        }
    }

    public static Set<class_703> getSync(class_3999 particleRenderType) {
        Set<class_703> set = SYNC_PARTICLES.get(particleRenderType);
        return set == null ? Collections.emptySet() : set;
    }

    private static void clearSync() {
        SYNC_PARTICLES.clear();
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    static void tryDebug() {
        if (debugConsumer != null) {
            debugConsumer.accept("[Debug AsyncRenderer]\nasync queue size: %d,\nbuffer capacity: %s,\nrender order: %s,\nsync particle count: %d,\nsync particle types: %s,\nsync particle render types: %s,\niris particle state: %s".formatted(asyncTasksSize, BTESSELATORS.entrySet().stream().filter(e -> !((BindingTesselator)((Object)((Object)e.getValue()))).shouldSync).collect(Collectors.toMap(Map.Entry::getKey, e -> ((BindingTesselator)((Object)((Object)e.getValue()))).field_52098.field_52083)), ModListHelper.IS_FORGE ? class_310.method_1551().field_1713.field_3830.keySet() : class_702.field_17820, SYNC_PARTICLES.values().stream().mapToInt(Set::size).sum(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList(), BTESSELATORS.entrySet().stream().filter(e -> ((BindingTesselator)((Object)((Object)e.getValue()))).shouldSync).map(Map.Entry::getKey).toList(), ModListHelper.IRIS_LIKE_LOADED && Iris.isPackInUseQuick() ? AsyncRenderer.getParticleRenderingSettings0().name() : "disabled"));
            debugConsumer = null;
        }
    }

    public static void reset() {
        AsyncRenderer.waitForAsyncTasks();
        AsyncRenderer.closeBTesselators();
        AsyncRenderer.clearSync();
    }

    static {
        SYNC_PARTICLE_TYPES.add(class_693.class);
        SYNC_PARTICLE_TYPES.add(class_700.class);
        if (ModListHelper.DUMMMMMMY_LOADED) {
            AsyncRenderer.addSyncByClassName("net.mehvahdjukaar.dummmmmmy.client.DamageNumberParticle");
        }
        if (ModListHelper.FABRIC_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("org.ladysnake.effective.particle.SplashParticle");
        }
        if (ModListHelper.FORGE_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("concerrox.effective.particle.SplashParticle");
        }
        if (ModListHelper.TOMBSTONE_LOADED) {
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleCasting");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGhost");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGraveSoul");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMagicCircle");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMarker");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleRounding");
        }
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
        mixedParticleRenderingSetting = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getRenderFailurePerSecondThreshold);
        BTESSELATORS = new ConcurrentHashMap<class_3999, BindingTesselator>();
        SYNC_PARTICLES = Collections.synchronizedMap(new IdentityHashMap());
    }
}

