/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client;

import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.create.CreateUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.WeatherParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import net.minecraft.world.phys.Vec3;

public class AsyncParticlesClient {
    public static final String MOD_ID = "asyncparticles";
    public static final String ISSUE_URL = "https://github.com/Harveykang/AsyncParticles/issues";

    public static void init() {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        try {
            ConfigHelper.load();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ModListHelper.PARTICLERAIN_LOADED && ModListHelper.CREATE_LOADED) {
            WeatherParticleAddon.Type.RAIN.register((level, position, motion, aabb) -> {
                Vec3 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                if (collide == null) {
                    return motion;
                }
                ParticleRainCompat.onCreateCollision(level, motion, collide, aabb);
                return collide;
            });
            WeatherParticleAddon.CollisionFunction function = (level, position, motion, aabb) -> {
                Vec3 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                return collide == null ? motion : collide;
            };
            WeatherParticleAddon.Type.SNOW.register(function);
            WeatherParticleAddon.Type.OTHER.register(function);
        }
    }
}

