/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.cooparticlesapi.CooTickMode;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ClothConfigMenus;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.FailBehavior;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.FallbackScreen;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.LegacyConfigMigrator;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.RainEffect;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.RenderingMode;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.TickMode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class AsyncParticlesConfig {
    public static final int VERSION = 1;
    public static final Path CONFIG_FILE = Path.of("config", "asyncparticles", "asyncparticles.json");
    static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().create();
    static final Logger LOGGER = LogUtils.getLogger();
    public static int particle$particleLimit;
    public static boolean particle$removeIfMissedTick;
    public static boolean particle$particleLightCache;
    public static boolean particle$cullUnderwaterParticleType;
    public static TickMode tick$animationTickMode;
    public static TickMode tick$particleTickMode;
    public static int tick$failPerSecLimit;
    public static FailBehavior tick$failBehavior;
    public static boolean tick$suppressCME;
    public static boolean rendering$cullParticles;
    public static RenderingMode rendering$particleRenderingMode;
    public static int rendering$failPerSecLimit;
    public static FailBehavior rendering$failBehavior;
    public static RainEffect valkyrienSkies$rainEffect;
    public static boolean valkyrienSkies$fixParticleLights;
    public static RainEffect create$rainEffect;
    public static CooTickMode cooparticlesapi$tickMode;

    public static Screen newConfigScreen(Screen parent) {
        if (ModListHelper.CLOTH_CONFIG_LOADED) {
            return ClothConfigMenus.screenBuilder(parent).build();
        }
        return AsyncParticlesConfig.fallBackScreen(parent);
    }

    private static Screen fallBackScreen(Screen parent) {
        FallbackScreen fallbackScreen = new FallbackScreen(parent, (Component)Component.translatable((String)"gui.asyncparticles.menu-unavailable"), (Component)Component.translatable((String)"gui.asyncparticles.menu-unavailable.message"), (Component)Component.translatable((String)"gui.back"), current -> Minecraft.getInstance().setScreen(current.parent), (Component)Component.translatable((String)"gui.asyncparticles.reload"), current -> Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(b -> {
            MutableComponent msg = Component.translatable((String)"gui.asyncparticles.menu-unavailable.message");
            if (!b) {
                current.message = msg;
                Minecraft.getInstance().setScreen((Screen)current);
                return;
            }
            try {
                AsyncParticlesConfig.load();
            }
            catch (Exception e) {
                current.message = msg.append("\n").append((Component)Component.translatable((String)"gui.asyncparticles.failed-to-reload", (Object[])new Object[]{e.toString()}).withStyle(ChatFormatting.DARK_RED));
                Minecraft.getInstance().setScreen((Screen)current);
                return;
            }
            finally {
                AsyncTicker.reloadLater();
            }
            current.message = msg.append("\n").append((Component)Component.translatable((String)"gui.asyncparticles.reload-successfully").withStyle(ChatFormatting.DARK_GREEN));
            Minecraft.getInstance().setScreen((Screen)current);
        }, (Component)Component.translatable((String)"gui.asyncparticles.menu-unavailable"), (Component)Component.translatable((String)"gui.asyncparticles.reload-confirmation"))));
        BiConsumer[] tickCallbacks = new BiConsumer[2];
        Consumer<FallbackScreen> reloadCallback = fallbackScreen.buttonRightCallback;
        tickCallbacks[0] = (fs, br) -> {
            if (!Screen.hasShiftDown()) {
                return;
            }
            br.setMessage((Component)Component.translatable((String)"gui.asyncparticles.reset").withStyle(ChatFormatting.RED));
            fs.buttonRightTick = tickCallbacks[1];
            fs.buttonRightCallback = current -> Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(b -> {
                MutableComponent msg = Component.translatable((String)"gui.asyncparticles.menu-unavailable.message");
                if (!b) {
                    current.message = msg;
                    Minecraft.getInstance().setScreen((Screen)current);
                    return;
                }
                try {
                    AsyncParticlesConfig.reset();
                }
                catch (Exception e) {
                    current.message = msg.append("\n").append((Component)Component.translatable((String)"gui.asyncparticles.failed-to-reset", (Object[])new Object[]{e.toString()}).withStyle(ChatFormatting.DARK_RED));
                    Minecraft.getInstance().setScreen((Screen)current);
                    return;
                }
                finally {
                    AsyncTicker.reloadLater();
                }
                current.message = msg.append("\n").append((Component)Component.translatable((String)"gui.asyncparticles.reset-successfully").withStyle(ChatFormatting.DARK_GREEN));
                Minecraft.getInstance().setScreen((Screen)current);
            }, (Component)Component.translatable((String)"gui.asyncparticles.menu-unavailable"), (Component)Component.translatable((String)"gui.asyncparticles.reset-confirmation").withStyle(ChatFormatting.RED)));
        };
        tickCallbacks[1] = (fs, br) -> {
            if (Screen.hasShiftDown()) {
                return;
            }
            br.setMessage((Component)Component.translatable((String)"gui.asyncparticles.reload"));
            fs.buttonRightTick = tickCallbacks[0];
            fs.buttonRightCallback = reloadCallback;
        };
        fallbackScreen.buttonRightTick = tickCallbacks[0];
        return fallbackScreen;
    }

    public static void load() throws IOException, JsonParseException {
        ConfigObj configObj;
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.createFile(CONFIG_FILE, new FileAttribute[0]);
            new ConfigObj().flat();
            if (LegacyConfigMigrator.migrate()) {
                AsyncParticlesConfig.save();
            } else {
                AsyncParticlesConfig.reset();
            }
            return;
        }
        try (BufferedReader json = Files.newBufferedReader(CONFIG_FILE);){
            configObj = (ConfigObj)GSON.fromJson((Reader)json, ConfigObj.class);
        }
        if (configObj == null) {
            AsyncParticlesConfig.reset();
            return;
        }
        configObj = AsyncParticlesConfig.upgrade(configObj.version, configObj);
        configObj.flat();
        AsyncParticlesConfig.save(configObj);
    }

    @Contract
    private static ConfigObj upgrade(int ver, ConfigObj configObj) {
        return switch (ver) {
            case 1 -> configObj;
            default -> new ConfigObj();
        };
    }

    public static void save() throws IOException, JsonParseException {
        ConfigObj configObj = new ConfigObj();
        configObj.fold();
        AsyncParticlesConfig.save(configObj);
    }

    public static void reset() throws IOException {
        ConfigObj configObj = new ConfigObj();
        configObj.flat();
        AsyncParticlesConfig.save(configObj);
    }

    private static void save(ConfigObj configObj) throws IOException {
        configObj.version = 1;
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
            GSON.toJson((Object)configObj, (Appendable)writer);
        }
    }

    static class ConfigObj {
        int version = 0;
        Particle particle = new Particle();
        Tick tick = new Tick();
        Rendering rendering = new Rendering();
        ValkyrienSkies valkyrienSkies = new ValkyrienSkies();
        Create create = new Create();
        CooParticlesAPI cooParticlesAPI = new CooParticlesAPI();

        ConfigObj() {
        }

        private void flat() {
            this.particle.flat();
            this.tick.flat();
            this.rendering.flat();
            this.valkyrienSkies.flat();
            this.create.flat();
            this.cooParticlesAPI.flat();
        }

        private void fold() {
            this.particle.fold();
            this.tick.fold();
            this.rendering.fold();
            this.valkyrienSkies.fold();
            this.create.fold();
            this.cooParticlesAPI.fold();
        }

        static class Particle {
            int particleLimit = ModListHelper.FABRIC_COO_PARTICLES_API_LOADED ? 65536 : 16384;
            boolean removeIfMissedTick = false;
            boolean particleLightCache = true;
            boolean cullUnderwaterParticleType = true;

            Particle() {
            }

            private void flat() {
                particle$particleLimit = Mth.clamp((int)this.particleLimit, (int)1024, (int)262144);
                particle$removeIfMissedTick = this.removeIfMissedTick;
                particle$particleLightCache = this.particleLightCache;
                particle$cullUnderwaterParticleType = this.cullUnderwaterParticleType;
            }

            private void fold() {
                this.particleLimit = particle$particleLimit;
                this.removeIfMissedTick = particle$removeIfMissedTick;
                this.particleLightCache = particle$particleLightCache;
                this.cullUnderwaterParticleType = particle$cullUnderwaterParticleType;
            }
        }

        static class Tick {
            TickMode animationTickMode = TickMode.INTERRUPTIBLE;
            TickMode particleTickMode = TickMode.INTERRUPTIBLE;
            int failPerSecLimit = 5;
            FailBehavior failBehavior = FailBehavior.RAISE_CRASH;
            boolean suppressCME = false;

            Tick() {
            }

            private void flat() {
                tick$animationTickMode = Objects.requireNonNullElse(this.animationTickMode, TickMode.INTERRUPTIBLE);
                tick$particleTickMode = Objects.requireNonNullElse(this.particleTickMode, TickMode.INTERRUPTIBLE);
                tick$failPerSecLimit = Mth.clamp((int)this.failPerSecLimit, (int)0, (int)256);
                tick$failBehavior = Objects.requireNonNullElse(this.failBehavior, FailBehavior.RAISE_CRASH);
                tick$suppressCME = this.suppressCME;
            }

            private void fold() {
                this.animationTickMode = tick$animationTickMode;
                this.particleTickMode = tick$particleTickMode;
                this.failPerSecLimit = tick$failPerSecLimit;
                this.failBehavior = tick$failBehavior;
                this.suppressCME = tick$suppressCME;
            }
        }

        static class Rendering {
            boolean cullParticles = true;
            RenderingMode particleRenderingMode = RenderingMode.DELAYED;
            int failPerSecLimit = 20;
            FailBehavior failBehavior = FailBehavior.MARK_AS_SYNC;

            Rendering() {
            }

            private void flat() {
                rendering$cullParticles = this.cullParticles;
                rendering$particleRenderingMode = Objects.requireNonNullElse(this.particleRenderingMode, RenderingMode.DELAYED);
                rendering$failPerSecLimit = Mth.clamp((int)this.failPerSecLimit, (int)0, (int)256);
                rendering$failBehavior = Objects.requireNonNullElse(this.failBehavior, FailBehavior.MARK_AS_SYNC);
            }

            private void fold() {
                this.cullParticles = rendering$cullParticles;
                this.particleRenderingMode = rendering$particleRenderingMode;
                this.failPerSecLimit = rendering$failPerSecLimit;
                this.failBehavior = rendering$failBehavior;
            }
        }

        static class ValkyrienSkies {
            RainEffect rainEffect = RainEffect.STATIONARY;
            boolean fixParticleLights = true;

            ValkyrienSkies() {
            }

            private void flat() {
                valkyrienSkies$rainEffect = Objects.requireNonNullElse(this.rainEffect, RainEffect.STATIONARY);
                valkyrienSkies$fixParticleLights = this.fixParticleLights;
            }

            private void fold() {
                this.rainEffect = valkyrienSkies$rainEffect;
                this.fixParticleLights = valkyrienSkies$fixParticleLights;
            }
        }

        static class Create {
            RainEffect rainEffect = RainEffect.ALWAYS;

            Create() {
            }

            private void flat() {
                create$rainEffect = Objects.requireNonNullElse(this.rainEffect, RainEffect.ALWAYS);
            }

            private void fold() {
                this.rainEffect = create$rainEffect;
            }
        }

        static class CooParticlesAPI {
            CooTickMode tickMode = CooTickMode.ASYNC_IN_PARALLEL;

            CooParticlesAPI() {
            }

            private void flat() {
                cooparticlesapi$tickMode = Objects.requireNonNullElse(this.tickMode, CooTickMode.ASYNC_IN_PARALLEL);
            }

            private void fold() {
                this.tickMode = cooparticlesapi$tickMode;
            }
        }
    }
}

