/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.fabric;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine_Render {
    @Shadow
    public Map<ParticleRenderType, Queue<Particle>> particles;
    @Shadow
    protected ClientLevel level;
    @Shadow
    @Final
    public TextureManager textureManager;
    @Shadow
    public static List<ParticleRenderType> RENDER_ORDER;

    @Overwrite
    public void render(LightTexture lightTexture, Camera camera, float f) {
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        boolean renderAsync = AsyncRenderer.isRenderAsync();
        if (renderAsync) {
            profiler.push("wait_for_async_tasks");
            AsyncRenderer.tryWaitForAsyncTasks();
            profiler.pop();
        }
        profiler.push("prepare");
        lightTexture.turnOnLightLayer();
        profiler.pop();
        Frustum frustum = AsyncRenderer.frustum;
        boolean cullParticles = ConfigHelper.isCullParticles();
        for (ParticleRenderType particleRenderType : RENDER_ORDER) {
            Tesselator toBegin;
            Collection<Particle> syncParticles;
            boolean enableCull;
            Queue<Particle> queue = this.particles.get(particleRenderType);
            if (queue == null || queue.isEmpty()) continue;
            BindingTesselator tesselator = AsyncRenderer.getBTesselator(particleRenderType, this.textureManager);
            profiler.push("render_sync");
            if (!renderAsync || tesselator.shouldSync) {
                enableCull = cullParticles;
                syncParticles = queue;
                toBegin = Tesselator.getInstance();
            } else {
                enableCull = false;
                syncParticles = AsyncRenderer.getSync(particleRenderType);
                toBegin = tesselator;
            }
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::getParticleShader);
            BufferBuilder bufferBuilder = particleRenderType.begin(toBegin, this.textureManager);
            if (bufferBuilder == null) continue;
            if (!syncParticles.isEmpty()) {
                float f2 = f + 1.0f;
                for (Particle particle : syncParticles) {
                    float f3;
                    if (!particle.isAlive()) continue;
                    float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    if (enableCull && !frustum.isVisible(((ParticleAddon)particle).getRenderBoundingBox(f3))) continue;
                    try {
                        particle.render((VertexConsumer)bufferBuilder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            profiler.popPush("build_buffer");
            MeshData meshData = bufferBuilder.build();
            if (meshData != null) {
                profiler.popPush("upload_particles");
                BufferUploader.drawWithShader((MeshData)meshData);
            }
            profiler.pop();
        }
        profiler.push("cleanup");
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        lightTexture.turnOffLightLayer();
        profiler.pop();
    }
}

