/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.blaze3d.pipeline.RenderTarget;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.culling.Frustum;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=500)
public abstract class MixinLevelRenderer {
    @Shadow
    @Nullable
    public PostChain transparencyChain;
    @Shadow
    @Nullable
    private Frustum capturedFrustum;
    @Shadow
    @Final
    private Vector3d frustumPos;
    @Shadow
    private Frustum cullingFrustum;

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevelHead(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci, @Share(namespace="asyncparticles", value="isRenderAsync") LocalBooleanRef isRenderAsync, @Share(namespace="asyncparticles", value="isMixedParticleRendering") LocalBooleanRef isMixedParticleRendering) {
        float f = deltaTracker.getGameTimeDeltaPartialTick(false);
        boolean b = ConfigHelper.isRenderAsync();
        isRenderAsync.set(b);
        if (this.capturedFrustum != null) {
            Frustum frustum = this.capturedFrustum;
            frustum.prepare(this.frustumPos.x, this.frustumPos.y, this.frustumPos.z);
            AsyncRenderer.frustum = frustum;
        } else {
            AsyncRenderer.frustum = this.cullingFrustum;
        }
        AsyncRenderer.captureParticleRenderingSetting();
        isMixedParticleRendering.set(AsyncRenderer.isMixedParticleRendering());
        AsyncRenderer.start(f, camera, b);
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/culling/Frustum;prepare(DDD)V"))
    private void redirectPrepare(Frustum frustum, double x, double y, double z) {
    }

    @Redirect(method={"renderLevel"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;particlesTarget:Lcom/mojang/blaze3d/pipeline/RenderTarget;")), at=@At(value="INVOKE", ordinal=0, target="Lcom/mojang/blaze3d/pipeline/RenderTarget;clear(Z)V"))
    private void redirectClearRenderTarget(RenderTarget instance, boolean bl, @Share(namespace="asyncparticles", value="isRenderAsync") LocalBooleanRef isRenderAsync) {
        if (!isRenderAsync.get()) {
            instance.clear(bl);
        }
    }

    @Redirect(method={"renderLevel"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;particlesTarget:Lcom/mojang/blaze3d/pipeline/RenderTarget;")), at=@At(value="INVOKE", ordinal=0, target="Lcom/mojang/blaze3d/pipeline/RenderTarget;copyDepthFrom(Lcom/mojang/blaze3d/pipeline/RenderTarget;)V"))
    private void redirectCopyDepthFrom(RenderTarget instance, RenderTarget target, @Share(namespace="asyncparticles", value="isRenderAsync") LocalBooleanRef isRenderAsync) {
        if (!isRenderAsync.get()) {
            instance.copyDepthFrom(target);
        }
    }

    @Redirect(method={"renderLevel"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderStateShard;PARTICLES_TARGET:Lnet/minecraft/client/renderer/RenderStateShard$OutputStateShard;")), at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/client/renderer/RenderStateShard$OutputStateShard;setupRenderState()V"))
    private void redirectSetupRenderState(RenderStateShard.OutputStateShard instance, @Share(namespace="asyncparticles", value="isRenderAsync") LocalBooleanRef isRenderAsync) {
        if (!isRenderAsync.get()) {
            instance.setupRenderState();
        }
    }

    @Redirect(method={"renderLevel"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderStateShard;PARTICLES_TARGET:Lnet/minecraft/client/renderer/RenderStateShard$OutputStateShard;")), at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/client/renderer/RenderStateShard$OutputStateShard;clearRenderState()V"))
    private void redirectClearRenderState(RenderStateShard.OutputStateShard instance, @Share(namespace="asyncparticles", value="isRenderAsync") LocalBooleanRef isRenderAsync) {
        if (!isRenderAsync.get()) {
            instance.clearRenderState();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/renderer/LevelRenderer;renderDebug(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/Camera;)V")})
    private void onRenderLevelTail(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci, @Local(ordinal=0) float partialTick, @Share(namespace="asyncparticles", value="isRenderAsync") LocalBooleanRef isRenderAsync, @Share(namespace="asyncparticles", value="isMixedParticleRendering") LocalBooleanRef isMixedParticleRendering) {
        if (isRenderAsync.get() && !isMixedParticleRendering.get() && !ConfigHelper.isCompatibilityRendering() && this.transparencyChain == null) {
            AsyncRenderer.endAll(partialTick, camera, lightTexture);
        }
    }

    @Inject(method={"renderLevel"}, order=1500, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/renderer/RenderStateShard;WEATHER_TARGET:Lnet/minecraft/client/renderer/RenderStateShard$OutputStateShard;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/PostChain;process(F)V")})
    private void onRenderLevelTail2(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci, @Local(ordinal=0) float partialTick, @Share(namespace="asyncparticles", value="isRenderAsync") LocalBooleanRef isRenderAsync, @Share(namespace="asyncparticles", value="isMixedParticleRendering") LocalBooleanRef isMixedParticleRendering) {
        if (isRenderAsync.get() && !isMixedParticleRendering.get() && !ConfigHelper.isCompatibilityRendering()) {
            AsyncRenderer.endAll(partialTick, camera, lightTexture);
        }
    }
}

