/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.tick;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.function.Supplier;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.api.EndTickOperation;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.GameUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class}, priority=1100)
public abstract class MixinClientLevel
extends Level {
    @Unique
    private static final ResourceLocation ANIMATE_TICK = GameUtil.id("animate_tick");

    protected MixinClientLevel(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        if (this.random.getClass() != SingleThreadedRandomSource.class) {
            this.random = new SingleThreadedRandomSource(RandomSupport.generateUniqueSeed());
        }
    }

    @WrapMethod(method={"animateTick"})
    public void animateTick(int i, int j, int k, Operation<Void> original) {
        if (!AsyncTicker.shouldTickParticles && ConfigHelper.isTickAsync()) {
            return;
        }
        if (!ConfigHelper.asyncBlockEntityAnimate()) {
            original.call(new Object[]{i, j, k});
        } else {
            EndTickOperation.schedule(ANIMATE_TICK, false, () -> original.call(new Object[]{i, j, k}));
        }
    }

    @Inject(method={"animateTick"}, at={@At(value="CONSTANT", args={"intValue=16"})}, cancellable=true)
    public void onAnimateTick(int i, int j, int k, CallbackInfo ci) {
        if (AsyncTicker.isCancelled() && !ConfigHelper.forceDoneBlockAnimateTick()) {
            ci.cancel();
        }
    }
}

