/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.tick;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.TrackedParticleCountsMap;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine {
    @Shadow
    public Queue<Particle> particlesToAdd;
    @Shadow
    public Map<ParticleRenderType, Queue<Particle>> particles;
    @Shadow
    protected ClientLevel level;
    @Shadow
    public Queue<TrackingEmitter> trackingEmitters;
    @Mutable
    @Shadow
    @Final
    private Object2IntOpenHashMap<ParticleGroup> trackedParticleCounts;
    @Mutable
    @Shadow
    @Final
    private RandomSource random;

    @Inject(method={"<init>"}, order=9000, at={@At(value="RETURN")})
    public void initTail(CallbackInfo ci) {
        this.trackedParticleCounts = new TrackedParticleCountsMap();
        this.particlesToAdd = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.trackingEmitters = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.random = new SingleThreadedRandomSource((long)ThreadLocalRandom.current().nextInt());
    }

    @Shadow
    public abstract void tickParticle(Particle var1);

    @Shadow
    public abstract void updateCount(ParticleGroup var1, int var2);

    @Inject(method={"tickParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReport;forThrowable(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/CrashReport;")})
    public void onTickParticle(Particle particle, CallbackInfo ci, @Local Throwable t) {
        if (ConfigHelper.isTickAsync()) {
            throw ExceptionUtil.toThrowDirectly(t);
        }
    }

    @Overwrite
    public void tick() {
        this.particles.forEach((particleRenderType, queue) -> {
            ProfilerFiller profiler = this.level.getProfiler();
            profiler.push(particleRenderType.toString());
            AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.tickParticleList((Collection<Particle>)queue));
            profiler.pop();
        });
        AsyncTicker.PARTICLE_OPERATIONS.add(this::asyncparticles$tickEmitters);
        boolean tickAsync = ConfigHelper.isTickAsync();
        if (tickAsync) {
            AsyncTicker.waitForCleanUp();
        } else {
            AsyncTicker.PARTICLE_OPERATIONS.forEach(Runnable::run);
            AsyncTicker.PARTICLE_OPERATIONS.clear();
            AsyncTicker.tickSyncParticles();
            this.particles.values().forEach(q -> q.removeIf(p -> {
                if (p.isAlive()) {
                    return false;
                }
                p.getParticleGroup().ifPresent(group -> this.updateCount((ParticleGroup)group, -1));
                return true;
            }));
        }
        if (!this.particlesToAdd.isEmpty()) {
            for (Particle particle : this.particlesToAdd) {
                if (tickAsync && ((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                }
                Queue queue2 = this.particles.computeIfAbsent(particle.getRenderType(), k -> {
                    IterationSafeEvictingQueue<Particle> queue1 = IterationSafeEvictingQueue.newInstance(16, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
                    if (tickAsync) {
                        AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.tickParticleList(queue1));
                    }
                    return queue1;
                });
                queue2.add(particle);
            }
            this.particlesToAdd.clear();
        }
    }

    @Unique
    private void asyncparticles$tickEmitters() {
        for (TrackingEmitter emitter : this.trackingEmitters) {
            if (AsyncTicker.isCancelled() && !ConfigHelper.forceDoneParticleTick()) {
                return;
            }
            if (!emitter.isAlive()) continue;
            if (!RenderSystem.isOnRenderThread() && ((ParticleAddon)emitter).asyncparticles$isTickSync()) {
                AsyncTicker.recordSync((Particle)emitter);
                continue;
            }
            try {
                emitter.tick();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException((Particle)emitter, t);
            }
        }
    }

    @Overwrite
    private void tickParticleList(Collection<Particle> collection) {
        if (collection.isEmpty()) {
            return;
        }
        boolean enableLightCache = ConfigHelper.particleLightCache();
        for (Particle particle : collection) {
            if (AsyncTicker.isCancelled() && !ConfigHelper.forceDoneParticleTick()) {
                return;
            }
            if (!particle.isAlive()) {
                Utils.DUMMY_ITERATOR.remove();
                continue;
            }
            if (!RenderSystem.isOnRenderThread()) {
                if (((ParticleAddon)particle).asyncparticles$isTicked()) {
                    if (!enableLightCache) continue;
                    ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    continue;
                }
                if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                    continue;
                }
            }
            try {
                this.tickParticle(particle);
                if (enableLightCache) {
                    ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                }
                ((ParticleAddon)particle).asyncparticles$setTicked();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException(particle, t);
            }
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")})
    public void add(Particle particle, CallbackInfo ci) {
        if (!AsyncTicker.shouldTickParticles && ConfigHelper.isTickAsync()) {
            particle.remove();
        } else if (ConfigHelper.particleLightCache()) {
            ((LightCachedParticleAddon)particle).asyncparticles$refresh();
        }
    }

    @Inject(method={"clearParticles"}, at={@At(value="HEAD")})
    public void onClearParticles(CallbackInfo ci) {
        this.particlesToAdd.forEach(AsyncTicker::onEvicted);
        this.particlesToAdd = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.trackingEmitters.forEach(AsyncTicker::onEvicted);
        this.trackingEmitters = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.particles.values().forEach(queue -> queue.forEach(AsyncTicker::onEvicted));
        AsyncTicker.onParticleEngineClear();
    }
}

