/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.SpinLock;

public class ReentrantSpinLock
implements SpinLock {
    private static final VarHandle OWNER;
    private volatile Thread owner;
    private int holdCount;

    @Override
    public void lock() {
        Thread currentThread = Thread.currentThread();
        if (!OWNER.compareAndSet(this, null, currentThread)) {
            if (currentThread == this.owner) {
                ++this.holdCount;
                return;
            }
            while (!OWNER.compareAndSet(this, null, currentThread)) {
                Thread.onSpinWait();
            }
        }
        this.holdCount = 1;
    }

    @Override
    public void unlock() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.owner) {
            throw new IllegalMonitorStateException("Attempt to unlock a lock held by another thread!");
        }
        if (--this.holdCount == 0) {
            this.owner = null;
        }
    }

    static {
        try {
            OWNER = MethodHandles.lookup().findVarHandle(ReentrantSpinLock.class, "owner", Thread.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

