/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import net.minecraft.client.Minecraft;

public class ThreadUtil {
    public static void assertNotParticleThread() {
        if (ThreadUtil.isOnParticleThread()) {
            throw new IllegalStateException("Cannot call this method from particle thread");
        }
    }

    public static void assertNotParticleRendererThread() {
        if (ThreadUtil.isOnParticleRendererThread()) {
            throw new IllegalStateException("Cannot call this method from particle renderer thread");
        }
    }

    public static void assertParticleRendererThread() {
        if (!ThreadUtil.isOnParticleRendererThread()) {
            throw new IllegalStateException("Cannot call this method from NON particle renderer thread");
        }
    }

    public static void assertNotParticleTickerThread() {
        if (ThreadUtil.isOnParticleTickerThread()) {
            throw new IllegalStateException("Cannot call this method from particle ticker thread");
        }
    }

    public static void assertParticleTickerThread() {
        if (!ThreadUtil.isOnParticleTickerThread()) {
            throw new IllegalStateException("Cannot call this method from NON particle ticker thread");
        }
    }

    public static boolean isOnParticleThread() {
        ForkJoinWorkerThread t;
        ForkJoinPool pool;
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread && ((pool = (t = (ForkJoinWorkerThread)thread).getPool()) == AsyncRenderer.EXECUTOR || pool == AsyncTicker.EXECUTOR);
    }

    public static boolean isOnParticleRendererThread() {
        ForkJoinWorkerThread t;
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread && (t = (ForkJoinWorkerThread)thread).getPool() == AsyncRenderer.EXECUTOR;
    }

    public static boolean isOnParticleTickerThread() {
        ForkJoinWorkerThread t;
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread && (t = (ForkJoinWorkerThread)thread).getPool() == AsyncTicker.EXECUTOR;
    }

    public static boolean isOnClientTickThread() {
        return RenderSystem.isOnRenderThread() || ThreadUtil.isOnParticleTickerThread();
    }

    public static void runOnClient(Runnable runnable) {
        Minecraft.getInstance().execute(runnable);
    }

    public static void enqueueClientTask(Runnable runnable) {
        Minecraft.getInstance().pendingRunnables.add(runnable);
    }
}

